/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.ArrayList;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.ExposedFields;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.data.mongodb.core.aggregation.RelaxedTypeBasedAggregationOperationContext;
import org.springframework.data.mongodb.core.convert.QueryMapper;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.util.Lazy;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class TypeBasedAggregationOperationContext
implements AggregationOperationContext {
    private final Class<?> type;
    private final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;
    private final QueryMapper mapper;
    private final Lazy<MongoPersistentEntity<?>> entity;

    public TypeBasedAggregationOperationContext(Class<?> type, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext, QueryMapper mapper) {
        Assert.notNull(type, "Type must not be null");
        Assert.notNull(mappingContext, "MappingContext must not be null");
        Assert.notNull((Object)mapper, "QueryMapper must not be null");
        this.type = type;
        this.mappingContext = mappingContext;
        this.mapper = mapper;
        this.entity = Lazy.of(() -> (MongoPersistentEntity)mappingContext.getPersistentEntity((MongoPersistentProperty)((Object)type)));
    }

    @Override
    public Document getMappedObject(Document document) {
        return this.getMappedObject(document, this.type);
    }

    @Override
    public Document getMappedObject(Document document, @Nullable Class<?> type) {
        return this.mapper.getMappedObject((Bson)document, type != null ? this.mappingContext.getPersistentEntity((MongoPersistentProperty)((Object)type)) : null);
    }

    @Override
    public ExposedFields.FieldReference getReference(Field field) {
        return this.getReferenceFor(field);
    }

    @Override
    public ExposedFields.FieldReference getReference(String name) {
        return this.getReferenceFor(Fields.field(name));
    }

    @Override
    public Fields getFields(Class<?> type) {
        Assert.notNull(type, "Type must not be null");
        MongoPersistentEntity<?> entity = this.mappingContext.getPersistentEntity((MongoPersistentProperty)((Object)type));
        if (entity == null) {
            return AggregationOperationContext.super.getFields(type);
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        for (MongoPersistentProperty property : entity) {
            fields.add(Fields.field(property.getName(), property.getFieldName()));
        }
        return Fields.from(fields.toArray(new Field[0]));
    }

    @Override
    public AggregationOperationContext continueOnMissingFieldReference() {
        return this.continueOnMissingFieldReference(this.type);
    }

    public AggregationOperationContext continueOnMissingFieldReference(Class<?> type) {
        return new RelaxedTypeBasedAggregationOperationContext(type, this.mappingContext, this.mapper);
    }

    protected ExposedFields.FieldReference getReferenceFor(Field field) {
        if (this.entity.getNullable() == null) {
            return new ExposedFields.DirectFieldReference(new ExposedFields.ExposedField(field, true));
        }
        PersistentPropertyPath<MongoPersistentProperty> propertyPath = this.mappingContext.getPersistentPropertyPath(field.getTarget(), this.type);
        Field mappedField = Fields.field(field.getName(), propertyPath.toDotPath(MongoPersistentProperty.PropertyToFieldNameConverter.INSTANCE));
        return new ExposedFields.DirectFieldReference(new ExposedFields.ExposedField(mappedField, true));
    }

    public Class<?> getType() {
        return this.type;
    }

    @Override
    public CodecRegistry getCodecRegistry() {
        return this.mapper.getConverter().getCodecRegistry();
    }
}

