/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.springframework.core.convert.ConversionService;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.annotation.Reference;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.mapping.PersistentPropertyPathAccessor;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.BeanWrapperPropertyAccessorFactory;
import org.springframework.data.mongodb.core.convert.LazyLoadingProxy;
import org.springframework.data.mongodb.core.mapping.DocumentPointer;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;

class DocumentPointerFactory {
    private final ConversionService conversionService;
    private final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;
    private final Map<String, LinkageDocument> cache;
    private static final Pattern DEFAULT_LOOKUP_PATTERN = Pattern.compile("\\{\\s?['\"]?_id['\"]??\\s?:\\s?['\"]?\\?#\\{#target\\}['\"]?\\s*}");

    DocumentPointerFactory(ConversionService conversionService, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
        this.conversionService = conversionService;
        this.mappingContext = mappingContext;
        this.cache = new WeakHashMap<String, LinkageDocument>();
    }

    DocumentPointer<?> computePointer(MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext, MongoPersistentProperty property, Object value, Class<?> typeHint) {
        if (value instanceof LazyLoadingProxy) {
            return () -> ((LazyLoadingProxy)value).getSource();
        }
        if (this.conversionService.canConvert(typeHint, DocumentPointer.class)) {
            return this.conversionService.convert(value, DocumentPointer.class);
        }
        MongoPersistentEntity<?> persistentEntity = mappingContext.getRequiredPersistentEntity((MongoPersistentProperty)((Object)property.getAssociationTargetType()));
        if (this.usesDefaultLookup(property)) {
            MongoPersistentProperty idProperty = (MongoPersistentProperty)persistentEntity.getIdProperty();
            Object idValue = persistentEntity.getIdentifierAccessor(value).getIdentifier();
            if (idProperty.hasExplicitWriteTarget() && this.conversionService.canConvert(idValue.getClass(), idProperty.getFieldType())) {
                return () -> this.conversionService.convert(idValue, idProperty.getFieldType());
            }
            if (idValue instanceof String && ObjectId.isValid((String)idValue)) {
                return () -> new ObjectId((String)idValue);
            }
            return () -> idValue;
        }
        MongoPersistentEntity<?> valueEntity = mappingContext.getPersistentEntity((MongoPersistentProperty)((Object)value.getClass()));
        PersistentPropertyAccessor<Object> propertyAccessor = valueEntity == null ? BeanWrapperPropertyAccessorFactory.INSTANCE.getPropertyAccessor(property.getOwner(), value) : valueEntity.getPropertyPathAccessor(value);
        return this.cache.computeIfAbsent(property.getDocumentReference().lookup(), LinkageDocument::from).getDocumentPointer(mappingContext, persistentEntity, propertyAccessor);
    }

    private boolean usesDefaultLookup(MongoPersistentProperty property) {
        if (property.isDocumentReference()) {
            return DEFAULT_LOOKUP_PATTERN.matcher(property.getDocumentReference().lookup()).matches();
        }
        Reference atReference = property.findAnnotation(Reference.class);
        if (atReference != null) {
            return true;
        }
        throw new IllegalStateException(String.format("%s does not seem to be define Reference", property));
    }

    static class LinkageDocument {
        static final Pattern EXPRESSION_PATTERN = Pattern.compile("\\?#\\{#?(?<fieldName>[\\w\\d\\.\\-)]*)\\}");
        static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("###_(?<index>\\d*)_###");
        private final String lookup;
        private final Document documentPointer;
        private final Map<String, String> placeholderMap;
        private final boolean isSimpleTargetPointer;

        static LinkageDocument from(String lookup) {
            return new LinkageDocument(lookup);
        }

        private LinkageDocument(String lookup) {
            this.lookup = lookup;
            this.placeholderMap = new LinkedHashMap<String, String>();
            int index = 0;
            Matcher matcher = EXPRESSION_PATTERN.matcher(lookup);
            String targetLookup = lookup;
            while (matcher.find()) {
                String expression = matcher.group();
                String fieldName = matcher.group("fieldName").replace("target.", "");
                String placeholder = this.placeholder(index);
                this.placeholderMap.put(placeholder, fieldName);
                targetLookup = targetLookup.replace(expression, "'" + placeholder + "'");
                ++index;
            }
            this.documentPointer = Document.parse(targetLookup);
            this.isSimpleTargetPointer = this.placeholderMap.size() == 1 && this.placeholderMap.containsValue("target") && lookup.contains("#target");
        }

        private String placeholder(int index) {
            return "###_" + index + "_###";
        }

        private boolean isPlaceholder(String key) {
            return PLACEHOLDER_PATTERN.matcher(key).matches();
        }

        DocumentPointer<Object> getDocumentPointer(MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext, MongoPersistentEntity<?> persistentEntity, PersistentPropertyAccessor<?> propertyAccessor) {
            return () -> this.updatePlaceholders(this.documentPointer, new Document(), mappingContext, persistentEntity, propertyAccessor);
        }

        Object updatePlaceholders(Document source, Document target, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext, MongoPersistentEntity<?> persistentEntity, PersistentPropertyAccessor<?> propertyAccessor) {
            for (Map.Entry<String, Object> entry : source.entrySet()) {
                if (entry.getKey().startsWith("$")) {
                    throw new InvalidDataAccessApiUsageException(String.format("Cannot derive document pointer from lookup '%s' using query operator (%s); Please consider registering a custom converter", this.lookup, entry.getKey()));
                }
                if (entry.getValue() instanceof Document) {
                    MongoPersistentProperty persistentProperty = (MongoPersistentProperty)persistentEntity.getPersistentProperty(entry.getKey());
                    if (persistentProperty != null && persistentProperty.isEntity()) {
                        MongoPersistentEntity<?> nestedEntity = mappingContext.getPersistentEntity((MongoPersistentProperty)((Object)persistentProperty.getType()));
                        target.put(entry.getKey(), this.updatePlaceholders((Document)entry.getValue(), new Document(), mappingContext, nestedEntity, nestedEntity.getPropertyAccessor(propertyAccessor.getProperty(persistentProperty))));
                        continue;
                    }
                    target.put(entry.getKey(), this.updatePlaceholders((Document)entry.getValue(), new Document(), mappingContext, persistentEntity, propertyAccessor));
                    continue;
                }
                if (this.placeholderMap.containsKey(entry.getValue())) {
                    String fieldName;
                    String attribute = this.placeholderMap.get(entry.getValue());
                    if (attribute.contains(".")) {
                        attribute = attribute.substring(attribute.lastIndexOf(46) + 1);
                    }
                    String string = fieldName = entry.getKey().equals("_id") ? "id" : entry.getKey();
                    if (!fieldName.contains(".")) {
                        Object targetValue = propertyAccessor.getProperty((PersistentProperty<?>)persistentEntity.getPersistentProperty(fieldName));
                        target.put(attribute, targetValue);
                        continue;
                    }
                    PersistentPropertyPathAccessor<?> propertyPathAccessor = persistentEntity.getPropertyPathAccessor(propertyAccessor.getBean());
                    PersistentPropertyPath<MongoPersistentProperty> path = mappingContext.getPersistentPropertyPath(PropertyPath.from(fieldName, persistentEntity.getTypeInformation()));
                    Object targetValue = propertyPathAccessor.getProperty(path);
                    target.put(attribute, targetValue);
                    continue;
                }
                target.put(entry.getKey(), entry.getValue());
            }
            if (target.size() == 1 && this.isSimpleTargetPointer) {
                return target.values().iterator().next();
            }
            return target;
        }
    }
}

