/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import com.mongodb.Function;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.bson.Document;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.data.geo.Box;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Metrics;
import org.springframework.data.geo.Point;
import org.springframework.data.geo.Polygon;
import org.springframework.data.geo.Shape;
import org.springframework.data.mongodb.core.geo.GeoJson;
import org.springframework.data.mongodb.core.geo.GeoJsonGeometryCollection;
import org.springframework.data.mongodb.core.geo.GeoJsonLineString;
import org.springframework.data.mongodb.core.geo.GeoJsonMultiLineString;
import org.springframework.data.mongodb.core.geo.GeoJsonMultiPoint;
import org.springframework.data.mongodb.core.geo.GeoJsonMultiPolygon;
import org.springframework.data.mongodb.core.geo.GeoJsonPoint;
import org.springframework.data.mongodb.core.geo.GeoJsonPolygon;
import org.springframework.data.mongodb.core.geo.Sphere;
import org.springframework.data.mongodb.core.query.GeoCommand;
import org.springframework.util.Assert;
import org.springframework.util.NumberUtils;
import org.springframework.util.ObjectUtils;

abstract class GeoConverters {
    private static final Map<String, Function<Document, GeoJson<?>>> converters;

    private GeoConverters() {
    }

    public static Collection<? extends Object> getConvertersToRegister() {
        return Arrays.asList(BoxToDocumentConverter.INSTANCE, PolygonToDocumentConverter.INSTANCE, CircleToDocumentConverter.INSTANCE, SphereToDocumentConverter.INSTANCE, DocumentToBoxConverter.INSTANCE, DocumentToPolygonConverter.INSTANCE, DocumentToCircleConverter.INSTANCE, DocumentToSphereConverter.INSTANCE, DocumentToPointConverter.INSTANCE, PointToDocumentConverter.INSTANCE, GeoCommandToDocumentConverter.INSTANCE, GeoJsonToDocumentConverter.INSTANCE, GeoJsonPointToDocumentConverter.INSTANCE, GeoJsonPolygonToDocumentConverter.INSTANCE, DocumentToGeoJsonPointConverter.INSTANCE, DocumentToGeoJsonPolygonConverter.INSTANCE, DocumentToGeoJsonLineStringConverter.INSTANCE, DocumentToGeoJsonMultiLineStringConverter.INSTANCE, DocumentToGeoJsonMultiPointConverter.INSTANCE, DocumentToGeoJsonMultiPolygonConverter.INSTANCE, DocumentToGeoJsonGeometryCollectionConverter.INSTANCE, DocumentToGeoJsonConverter.INSTANCE);
    }

    static List<Double> toList(Point point) {
        return Arrays.asList(point.getX(), point.getY());
    }

    static List<Point> toListOfPoint(List<?> listOfCoordinatePairs) {
        ArrayList<Point> points = new ArrayList<Point>(listOfCoordinatePairs.size());
        for (Object point : listOfCoordinatePairs) {
            Assert.isInstanceOf(List.class, point);
            List coordinatesList = (List)point;
            points.add(new GeoJsonPoint(GeoConverters.toPrimitiveDoubleValue(coordinatesList.get(0)), GeoConverters.toPrimitiveDoubleValue(coordinatesList.get(1))));
        }
        return points;
    }

    static GeoJsonPolygon toGeoJsonPolygon(List<?> dbList) {
        GeoJsonPolygon polygon = new GeoJsonPolygon(GeoConverters.toListOfPoint((List)dbList.get(0)));
        return dbList.size() > 1 ? polygon.withInnerRing(GeoConverters.toListOfPoint((List)dbList.get(1))) : polygon;
    }

    private static GeoJson<?> toGenericGeoJson(Document source) {
        Function<Document, GeoJson<?>> converter;
        String type = (String)((Object)source.get((Object)"type", String.class));
        if (type != null && (converter = converters.get(type)) != null) {
            return converter.apply(source);
        }
        throw new IllegalArgumentException(String.format("No converter found capable of converting GeoJson type %s", type));
    }

    private static double toPrimitiveDoubleValue(Object value) {
        Assert.isInstanceOf(Number.class, value, "Argument must be a Number");
        return NumberUtils.convertNumberToTargetClass((Number)value, Double.class);
    }

    static {
        Collator caseInsensitive = Collator.getInstance();
        caseInsensitive.setStrength(0);
        TreeMap geoConverters = new TreeMap(caseInsensitive);
        geoConverters.put("point", DocumentToGeoJsonPointConverter.INSTANCE::convert);
        geoConverters.put("multipoint", DocumentToGeoJsonMultiPointConverter.INSTANCE::convert);
        geoConverters.put("linestring", DocumentToGeoJsonLineStringConverter.INSTANCE::convert);
        geoConverters.put("multilinestring", DocumentToGeoJsonMultiLineStringConverter.INSTANCE::convert);
        geoConverters.put("polygon", DocumentToGeoJsonPolygonConverter.INSTANCE::convert);
        geoConverters.put("multipolygon", DocumentToGeoJsonMultiPolygonConverter.INSTANCE::convert);
        geoConverters.put("geometrycollection", DocumentToGeoJsonGeometryCollectionConverter.INSTANCE::convert);
        converters = geoConverters;
    }

    @WritingConverter
    static enum BoxToDocumentConverter implements Converter<Box, Document>
    {
        INSTANCE;


        @Override
        public Document convert(Box source) {
            if (source == null) {
                return null;
            }
            Document result = new Document();
            result.put("first", (Object)PointToDocumentConverter.INSTANCE.convert(source.getFirst()));
            result.put("second", (Object)PointToDocumentConverter.INSTANCE.convert(source.getSecond()));
            return result;
        }
    }

    static enum PolygonToDocumentConverter implements Converter<Polygon, Document>
    {
        INSTANCE;


        @Override
        public Document convert(Polygon source) {
            if (source == null) {
                return null;
            }
            List<Point> points = source.getPoints();
            ArrayList<Document> pointTuples = new ArrayList<Document>(points.size());
            for (Point point : points) {
                pointTuples.add(PointToDocumentConverter.INSTANCE.convert(point));
            }
            Document result = new Document();
            result.put("points", (Object)pointTuples);
            return result;
        }
    }

    static enum CircleToDocumentConverter implements Converter<Circle, Document>
    {
        INSTANCE;


        @Override
        public Document convert(Circle source) {
            if (source == null) {
                return null;
            }
            Document result = new Document();
            result.put("center", (Object)PointToDocumentConverter.INSTANCE.convert(source.getCenter()));
            result.put("radius", (Object)source.getRadius().getNormalizedValue());
            result.put("metric", (Object)source.getRadius().getMetric().toString());
            return result;
        }
    }

    static enum SphereToDocumentConverter implements Converter<Sphere, Document>
    {
        INSTANCE;


        @Override
        public Document convert(Sphere source) {
            if (source == null) {
                return null;
            }
            Document result = new Document();
            result.put("center", (Object)PointToDocumentConverter.INSTANCE.convert(source.getCenter()));
            result.put("radius", (Object)source.getRadius().getNormalizedValue());
            result.put("metric", (Object)source.getRadius().getMetric().toString());
            return result;
        }
    }

    @ReadingConverter
    static enum DocumentToBoxConverter implements Converter<Document, Box>
    {
        INSTANCE;


        @Override
        public Box convert(Document source) {
            if (source == null) {
                return null;
            }
            Point first = DocumentToPointConverter.INSTANCE.convert((Document)source.get("first"));
            Point second = DocumentToPointConverter.INSTANCE.convert((Document)source.get("second"));
            return new Box(first, second);
        }
    }

    @ReadingConverter
    static enum DocumentToPolygonConverter implements Converter<Document, Polygon>
    {
        INSTANCE;


        @Override
        public Polygon convert(Document source) {
            if (source == null) {
                return null;
            }
            List points = (List)source.get("points");
            ArrayList<Point> newPoints = new ArrayList<Point>(points.size());
            for (Document element : points) {
                Assert.notNull((Object)element, "Point elements of polygon must not be null");
                newPoints.add(DocumentToPointConverter.INSTANCE.convert(element));
            }
            return new Polygon(newPoints);
        }
    }

    @ReadingConverter
    static enum DocumentToCircleConverter implements Converter<Document, Circle>
    {
        INSTANCE;


        @Override
        public Circle convert(Document source) {
            if (source == null) {
                return null;
            }
            Document center = (Document)source.get("center");
            Number radius = (Number)source.get("radius");
            Assert.notNull((Object)center, "Center must not be null");
            Assert.notNull((Object)radius, "Radius must not be null");
            Distance distance = new Distance(GeoConverters.toPrimitiveDoubleValue(radius));
            if (source.containsKey("metric")) {
                String metricString = (String)source.get("metric");
                Assert.notNull((Object)metricString, "Metric must not be null");
                distance = distance.in(Metrics.valueOf(metricString));
            }
            return new Circle(DocumentToPointConverter.INSTANCE.convert(center), distance);
        }
    }

    @ReadingConverter
    static enum DocumentToSphereConverter implements Converter<Document, Sphere>
    {
        INSTANCE;


        @Override
        public Sphere convert(Document source) {
            if (source == null) {
                return null;
            }
            Document center = (Document)source.get("center");
            Number radius = (Number)source.get("radius");
            Assert.notNull((Object)center, "Center must not be null");
            Assert.notNull((Object)radius, "Radius must not be null");
            Distance distance = new Distance(GeoConverters.toPrimitiveDoubleValue(radius));
            if (source.containsKey("metric")) {
                String metricString = (String)source.get("metric");
                Assert.notNull((Object)metricString, "Metric must not be null");
                distance = distance.in(Metrics.valueOf(metricString));
            }
            return new Sphere(DocumentToPointConverter.INSTANCE.convert(center), distance);
        }
    }

    @ReadingConverter
    static enum DocumentToPointConverter implements Converter<Document, Point>
    {
        INSTANCE;


        @Override
        public Point convert(Document source) {
            if (source == null) {
                return null;
            }
            Assert.isTrue(source.keySet().size() == 2, "Source must contain 2 elements");
            if (source.containsKey("type")) {
                return DocumentToGeoJsonPointConverter.INSTANCE.convert(source);
            }
            return new Point(GeoConverters.toPrimitiveDoubleValue(source.get("x")), GeoConverters.toPrimitiveDoubleValue(source.get("y")));
        }
    }

    static enum PointToDocumentConverter implements Converter<Point, Document>
    {
        INSTANCE;


        @Override
        public Document convert(Point source) {
            return source == null ? null : new Document("x", source.getX()).append("y", source.getY());
        }
    }

    static enum GeoCommandToDocumentConverter implements Converter<GeoCommand, Document>
    {
        INSTANCE;


        @Override
        public Document convert(GeoCommand source) {
            if (source == null) {
                return null;
            }
            ArrayList<Object> argument = new ArrayList<Object>(2);
            Shape shape = source.getShape();
            if (shape instanceof GeoJson) {
                return GeoJsonToDocumentConverter.INSTANCE.convert((GeoJson)((Object)shape));
            }
            if (shape instanceof Box) {
                argument.add(GeoConverters.toList(((Box)shape).getFirst()));
                argument.add(GeoConverters.toList(((Box)shape).getSecond()));
            } else if (shape instanceof Circle) {
                argument.add(GeoConverters.toList(((Circle)shape).getCenter()));
                argument.add(((Circle)shape).getRadius().getNormalizedValue());
            } else if (shape instanceof Polygon) {
                List<Point> points = ((Polygon)shape).getPoints();
                argument = new ArrayList(points.size());
                for (Point point : points) {
                    argument.add(GeoConverters.toList(point));
                }
            } else if (shape instanceof Sphere) {
                argument.add(GeoConverters.toList(((Sphere)shape).getCenter()));
                argument.add(((Sphere)shape).getRadius().getNormalizedValue());
            }
            return new Document(source.getCommand(), argument);
        }
    }

    static enum GeoJsonToDocumentConverter implements Converter<GeoJson<?>, Document>
    {
        INSTANCE;


        @Override
        public Document convert(GeoJson<?> source) {
            if (source == null) {
                return null;
            }
            Document dbo = new Document("type", source.getType());
            if (source instanceof GeoJsonGeometryCollection) {
                ArrayList<Document> dbl = new ArrayList<Document>();
                for (GeoJson<?> geometry : ((GeoJsonGeometryCollection)source).getCoordinates()) {
                    dbl.add(this.convert(geometry));
                }
                dbo.put("geometries", (Object)dbl);
            } else {
                dbo.put("coordinates", this.convertIfNecessary(source.getCoordinates()));
            }
            return dbo;
        }

        private Object convertIfNecessary(Object candidate) {
            if (candidate instanceof GeoJson) {
                return this.convertIfNecessary(((GeoJson)candidate).getCoordinates());
            }
            if (candidate instanceof Iterable) {
                ArrayList<Object> dbl = new ArrayList<Object>();
                for (Object element : (Iterable)candidate) {
                    dbl.add(this.convertIfNecessary(element));
                }
                return dbl;
            }
            if (candidate instanceof Point) {
                return GeoConverters.toList((Point)candidate);
            }
            return candidate;
        }
    }

    static enum GeoJsonPointToDocumentConverter implements Converter<GeoJsonPoint, Document>
    {
        INSTANCE;


        @Override
        public Document convert(GeoJsonPoint source) {
            return GeoJsonToDocumentConverter.INSTANCE.convert(source);
        }
    }

    static enum GeoJsonPolygonToDocumentConverter implements Converter<GeoJsonPolygon, Document>
    {
        INSTANCE;


        @Override
        public Document convert(GeoJsonPolygon source) {
            return GeoJsonToDocumentConverter.INSTANCE.convert(source);
        }
    }

    static enum DocumentToGeoJsonPointConverter implements Converter<Document, GeoJsonPoint>
    {
        INSTANCE;


        @Override
        public GeoJsonPoint convert(Document source) {
            if (source == null) {
                return null;
            }
            Assert.isTrue(ObjectUtils.nullSafeEquals(source.get("type"), "Point"), String.format("Cannot convert type '%s' to Point", source.get("type")));
            List dbl = (List)source.get("coordinates");
            return new GeoJsonPoint(GeoConverters.toPrimitiveDoubleValue(dbl.get(0)), GeoConverters.toPrimitiveDoubleValue(dbl.get(1)));
        }
    }

    static enum DocumentToGeoJsonPolygonConverter implements Converter<Document, GeoJsonPolygon>
    {
        INSTANCE;


        @Override
        public GeoJsonPolygon convert(Document source) {
            if (source == null) {
                return null;
            }
            Assert.isTrue(ObjectUtils.nullSafeEquals(source.get("type"), "Polygon"), String.format("Cannot convert type '%s' to Polygon", source.get("type")));
            return GeoConverters.toGeoJsonPolygon((List)source.get("coordinates"));
        }
    }

    static enum DocumentToGeoJsonLineStringConverter implements Converter<Document, GeoJsonLineString>
    {
        INSTANCE;


        @Override
        public GeoJsonLineString convert(Document source) {
            if (source == null) {
                return null;
            }
            Assert.isTrue(ObjectUtils.nullSafeEquals(source.get("type"), "LineString"), String.format("Cannot convert type '%s' to LineString", source.get("type")));
            List cords = (List)source.get("coordinates");
            return new GeoJsonLineString(GeoConverters.toListOfPoint(cords));
        }
    }

    static enum DocumentToGeoJsonMultiLineStringConverter implements Converter<Document, GeoJsonMultiLineString>
    {
        INSTANCE;


        @Override
        public GeoJsonMultiLineString convert(Document source) {
            if (source == null) {
                return null;
            }
            Assert.isTrue(ObjectUtils.nullSafeEquals(source.get("type"), "MultiLineString"), String.format("Cannot convert type '%s' to MultiLineString", source.get("type")));
            ArrayList<GeoJsonLineString> lines = new ArrayList<GeoJsonLineString>();
            List cords = (List)source.get("coordinates");
            for (Object line : cords) {
                lines.add(new GeoJsonLineString(GeoConverters.toListOfPoint((List)line)));
            }
            return new GeoJsonMultiLineString((List<GeoJsonLineString>)lines);
        }
    }

    static enum DocumentToGeoJsonMultiPointConverter implements Converter<Document, GeoJsonMultiPoint>
    {
        INSTANCE;


        @Override
        public GeoJsonMultiPoint convert(Document source) {
            if (source == null) {
                return null;
            }
            Assert.isTrue(ObjectUtils.nullSafeEquals(source.get("type"), "MultiPoint"), String.format("Cannot convert type '%s' to MultiPoint", source.get("type")));
            List cords = (List)source.get("coordinates");
            return new GeoJsonMultiPoint(GeoConverters.toListOfPoint(cords));
        }
    }

    static enum DocumentToGeoJsonMultiPolygonConverter implements Converter<Document, GeoJsonMultiPolygon>
    {
        INSTANCE;


        @Override
        public GeoJsonMultiPolygon convert(Document source) {
            if (source == null) {
                return null;
            }
            Assert.isTrue(ObjectUtils.nullSafeEquals(source.get("type"), "MultiPolygon"), String.format("Cannot convert type '%s' to MultiPolygon", source.get("type")));
            List dbl = (List)source.get("coordinates");
            ArrayList<GeoJsonPolygon> polygones = new ArrayList<GeoJsonPolygon>();
            for (Object polygon : dbl) {
                polygones.add(GeoConverters.toGeoJsonPolygon((List)polygon));
            }
            return new GeoJsonMultiPolygon(polygones);
        }
    }

    static enum DocumentToGeoJsonGeometryCollectionConverter implements Converter<Document, GeoJsonGeometryCollection>
    {
        INSTANCE;


        @Override
        public GeoJsonGeometryCollection convert(Document source) {
            if (source == null) {
                return null;
            }
            Assert.isTrue(ObjectUtils.nullSafeEquals(source.get("type"), "GeometryCollection"), String.format("Cannot convert type '%s' to GeometryCollection", source.get("type")));
            ArrayList geometries = new ArrayList();
            for (Object o : (List)source.get("geometries")) {
                geometries.add(GeoConverters.toGenericGeoJson((Document)o));
            }
            return new GeoJsonGeometryCollection(geometries);
        }
    }

    @ReadingConverter
    static enum DocumentToGeoJsonConverter implements Converter<Document, GeoJson<?>>
    {
        INSTANCE;


        @Override
        public GeoJson<?> convert(Document source) {
            return GeoConverters.toGenericGeoJson(source);
        }
    }
}

