/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import org.bson.conversions.Bson;
import org.springframework.data.convert.ValueConversionContext;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;

public class MongoConversionContext
implements ValueConversionContext<MongoPersistentProperty> {
    private final MongoPersistentProperty persistentProperty;
    private final MongoConverter mongoConverter;

    public MongoConversionContext(MongoPersistentProperty persistentProperty, MongoConverter mongoConverter) {
        this.persistentProperty = persistentProperty;
        this.mongoConverter = mongoConverter;
    }

    @Override
    public MongoPersistentProperty getProperty() {
        return this.persistentProperty;
    }

    @Override
    public <T> T write(@Nullable Object value, TypeInformation<T> target) {
        return (T)this.mongoConverter.convertToMongoType(value, target);
    }

    @Override
    public <T> T read(@Nullable Object value, TypeInformation<T> target) {
        return value instanceof Bson ? this.mongoConverter.read(target.getType(), (Bson)value) : ValueConversionContext.super.read(value, target);
    }
}

