/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import com.mongodb.DBRef;
import com.mongodb.MongoClientSettings;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.springframework.core.convert.ConversionException;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.convert.EntityConverter;
import org.springframework.data.convert.EntityReader;
import org.springframework.data.mongodb.CodecRegistryProvider;
import org.springframework.data.mongodb.core.convert.DbRefResolver;
import org.springframework.data.mongodb.core.convert.MongoTypeMapper;
import org.springframework.data.mongodb.core.convert.MongoWriter;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.util.BsonUtils;
import org.springframework.data.projection.EntityProjection;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public interface MongoConverter
extends EntityConverter<MongoPersistentEntity<?>, MongoPersistentProperty, Object, Bson>,
MongoWriter<Object>,
EntityReader<Object, Bson>,
CodecRegistryProvider {
    public MongoTypeMapper getTypeMapper();

    public ProjectionFactory getProjectionFactory();

    public CustomConversions getCustomConversions();

    public <R> R project(EntityProjection<R, ?> var1, Bson var2);

    @Nullable
    default public <S, T> T mapValueToTargetType(S source, Class<T> targetType, DbRefResolver dbRefResolver) {
        Assert.notNull(targetType, "TargetType must not be null");
        Assert.notNull((Object)dbRefResolver, "DbRefResolver must not be null");
        if (targetType != Object.class && ClassUtils.isAssignable(targetType, source.getClass())) {
            return (T)source;
        }
        if (source instanceof BsonValue) {
            Object value = BsonUtils.toJavaType((BsonValue)source);
            if (value instanceof Document) {
                Document sourceDocument = (Document)value;
                if (sourceDocument.containsKey("$ref") && sourceDocument.containsKey("$id")) {
                    DBRef ref;
                    Object id = sourceDocument.get("$id");
                    String collection = sourceDocument.getString("$ref");
                    MongoPersistentEntity entity = (MongoPersistentEntity)this.getMappingContext().getPersistentEntity(targetType);
                    if (entity != null && entity.hasIdProperty()) {
                        id = this.convertId(id, ((MongoPersistentProperty)entity.getIdProperty()).getFieldType());
                    }
                    if ((sourceDocument = dbRefResolver.fetch(ref = sourceDocument.containsKey("$db") ? new DBRef(sourceDocument.getString("$db"), collection, id) : new DBRef(collection, id))) == null) {
                        return null;
                    }
                }
                return this.read(targetType, sourceDocument);
            }
            if (!ClassUtils.isAssignable(targetType, value.getClass()) && this.getConversionService().canConvert(value.getClass(), targetType)) {
                return this.getConversionService().convert(value, targetType);
            }
            return (T)value;
        }
        return this.getConversionService().convert(source, targetType);
    }

    @Nullable
    default public Object convertId(@Nullable Object id, Class<?> targetType) {
        if (id == null || ClassUtils.isAssignableValue(targetType, id)) {
            return id;
        }
        if (ClassUtils.isAssignable(ObjectId.class, targetType) && id instanceof String) {
            if (ObjectId.isValid(id.toString())) {
                return new ObjectId(id.toString());
            }
            return id;
        }
        try {
            return this.getConversionService().canConvert(id.getClass(), targetType) ? this.getConversionService().convert(id, targetType) : this.convertToMongoType(id, (TypeInformation)null);
        }
        catch (ConversionException o_O) {
            return this.convertToMongoType(id, (TypeInformation)null);
        }
    }

    @Override
    default public CodecRegistry getCodecRegistry() {
        return MongoClientSettings.getDefaultCodecRegistry();
    }
}

