/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import com.mongodb.MongoClientSettings;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Currency;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.bson.BsonReader;
import org.bson.BsonTimestamp;
import org.bson.BsonWriter;
import org.bson.Document;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.types.Binary;
import org.bson.types.Code;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalConverter;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.data.convert.ConverterBuilder;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.data.mongodb.core.query.Term;
import org.springframework.data.mongodb.core.script.NamedMongoScript;
import org.springframework.util.Assert;
import org.springframework.util.NumberUtils;
import org.springframework.util.StringUtils;

abstract class MongoConverters {
    private MongoConverters() {
    }

    static Collection<Object> getConvertersToRegister() {
        ArrayList<Object> converters = new ArrayList<Object>();
        converters.add(BigDecimalToStringConverter.INSTANCE);
        converters.add(BigDecimalToDecimal128Converter.INSTANCE);
        converters.add(StringToBigDecimalConverter.INSTANCE);
        converters.add(Decimal128ToBigDecimalConverter.INSTANCE);
        converters.add(BigIntegerToStringConverter.INSTANCE);
        converters.add(StringToBigIntegerConverter.INSTANCE);
        converters.add(URLToStringConverter.INSTANCE);
        converters.add(StringToURLConverter.INSTANCE);
        converters.add(DocumentToStringConverter.INSTANCE);
        converters.add(TermToStringConverter.INSTANCE);
        converters.add(NamedMongoScriptToDocumentConverter.INSTANCE);
        converters.add(DocumentToNamedMongoScriptConverter.INSTANCE);
        converters.add(CurrencyToStringConverter.INSTANCE);
        converters.add(StringToCurrencyConverter.INSTANCE);
        converters.add(AtomicIntegerToIntegerConverter.INSTANCE);
        converters.add(AtomicLongToLongConverter.INSTANCE);
        converters.add(LongToAtomicLongConverter.INSTANCE);
        converters.add(IntegerToAtomicIntegerConverter.INSTANCE);
        converters.add(BinaryToByteArrayConverter.INSTANCE);
        converters.add(BsonTimestampToInstantConverter.INSTANCE);
        converters.add(ConverterBuilder.reading(String.class, URI.class, URI::create).andWriting(URI::toString));
        return converters;
    }

    static enum BigDecimalToStringConverter implements Converter<BigDecimal, String>
    {
        INSTANCE;


        @Override
        public String convert(BigDecimal source) {
            return source.toString();
        }
    }

    static enum BigDecimalToDecimal128Converter implements Converter<BigDecimal, Decimal128>
    {
        INSTANCE;


        @Override
        public Decimal128 convert(BigDecimal source) {
            return new Decimal128(source);
        }
    }

    static enum StringToBigDecimalConverter implements Converter<String, BigDecimal>
    {
        INSTANCE;


        @Override
        public BigDecimal convert(String source) {
            return StringUtils.hasText(source) ? new BigDecimal(source) : null;
        }
    }

    static enum Decimal128ToBigDecimalConverter implements Converter<Decimal128, BigDecimal>
    {
        INSTANCE;


        @Override
        public BigDecimal convert(Decimal128 source) {
            return source.bigDecimalValue();
        }
    }

    static enum BigIntegerToStringConverter implements Converter<BigInteger, String>
    {
        INSTANCE;


        @Override
        public String convert(BigInteger source) {
            return source.toString();
        }
    }

    static enum StringToBigIntegerConverter implements Converter<String, BigInteger>
    {
        INSTANCE;


        @Override
        public BigInteger convert(String source) {
            return StringUtils.hasText(source) ? new BigInteger(source) : null;
        }
    }

    static enum URLToStringConverter implements Converter<URL, String>
    {
        INSTANCE;


        @Override
        public String convert(URL source) {
            return source.toString();
        }
    }

    static enum StringToURLConverter implements Converter<String, URL>
    {
        INSTANCE;

        private static final TypeDescriptor SOURCE;
        private static final TypeDescriptor TARGET;

        @Override
        public URL convert(String source) {
            try {
                return new URL(source);
            }
            catch (MalformedURLException e) {
                throw new ConversionFailedException(SOURCE, TARGET, source, e);
            }
        }

        static {
            SOURCE = TypeDescriptor.valueOf(String.class);
            TARGET = TypeDescriptor.valueOf(URL.class);
        }
    }

    @ReadingConverter
    static enum DocumentToStringConverter implements Converter<Document, String>
    {
        INSTANCE;

        private final Codec<Document> codec = CodecRegistries.fromRegistries(CodecRegistries.fromCodecs(new Codec<UUID>(){

            @Override
            public void encode(BsonWriter writer, UUID value, EncoderContext encoderContext) {
                writer.writeString(value.toString());
            }

            @Override
            public Class<UUID> getEncoderClass() {
                return UUID.class;
            }

            @Override
            public UUID decode(BsonReader reader, DecoderContext decoderContext) {
                throw new IllegalStateException("decode not supported");
            }
        }), MongoClientSettings.getDefaultCodecRegistry()).get(Document.class);

        @Override
        public String convert(Document source) {
            return source.toJson(this.codec);
        }
    }

    @WritingConverter
    static enum TermToStringConverter implements Converter<Term, String>
    {
        INSTANCE;


        @Override
        public String convert(Term source) {
            return source.getFormatted();
        }
    }

    static enum NamedMongoScriptToDocumentConverter implements Converter<NamedMongoScript, Document>
    {
        INSTANCE;


        @Override
        public Document convert(NamedMongoScript source) {
            Document document = new Document();
            document.put("_id", (Object)source.getName());
            document.put("value", (Object)new Code(source.getCode()));
            return document;
        }
    }

    static enum DocumentToNamedMongoScriptConverter implements Converter<Document, NamedMongoScript>
    {
        INSTANCE;


        @Override
        public NamedMongoScript convert(Document source) {
            if (source.isEmpty()) {
                return null;
            }
            String id = source.get("_id").toString();
            Object rawValue = source.get("value");
            return new NamedMongoScript(id, ((Code)rawValue).getCode());
        }
    }

    @WritingConverter
    static enum CurrencyToStringConverter implements Converter<Currency, String>
    {
        INSTANCE;


        @Override
        public String convert(Currency source) {
            return source.getCurrencyCode();
        }
    }

    @ReadingConverter
    static enum StringToCurrencyConverter implements Converter<String, Currency>
    {
        INSTANCE;


        @Override
        public Currency convert(String source) {
            return StringUtils.hasText(source) ? Currency.getInstance(source) : null;
        }
    }

    @WritingConverter
    static enum AtomicIntegerToIntegerConverter implements Converter<AtomicInteger, Integer>
    {
        INSTANCE;


        @Override
        public Integer convert(AtomicInteger source) {
            return NumberUtils.convertNumberToTargetClass(source, Integer.class);
        }
    }

    @WritingConverter
    static enum AtomicLongToLongConverter implements Converter<AtomicLong, Long>
    {
        INSTANCE;


        @Override
        public Long convert(AtomicLong source) {
            return NumberUtils.convertNumberToTargetClass(source, Long.class);
        }
    }

    @ReadingConverter
    static enum LongToAtomicLongConverter implements Converter<Long, AtomicLong>
    {
        INSTANCE;


        @Override
        public AtomicLong convert(Long source) {
            return new AtomicLong(source);
        }
    }

    @ReadingConverter
    static enum IntegerToAtomicIntegerConverter implements Converter<Integer, AtomicInteger>
    {
        INSTANCE;


        @Override
        public AtomicInteger convert(Integer source) {
            return new AtomicInteger(source);
        }
    }

    @ReadingConverter
    static enum BinaryToByteArrayConverter implements Converter<Binary, byte[]>
    {
        INSTANCE;


        @Override
        public byte[] convert(Binary source) {
            return source.getData();
        }
    }

    @ReadingConverter
    static enum BsonTimestampToInstantConverter implements Converter<BsonTimestamp, Instant>
    {
        INSTANCE;


        @Override
        public Instant convert(BsonTimestamp source) {
            return Instant.ofEpochSecond(source.getTime(), 0L);
        }
    }

    @WritingConverter
    static enum NumberToNumberConverterFactory implements ConverterFactory<Number, Number>,
    ConditionalConverter
    {
        INSTANCE;


        @Override
        public <T extends Number> Converter<Number, T> getConverter(Class<T> targetType) {
            return new NumberToNumberConverter<T>(targetType);
        }

        @Override
        public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
            return !sourceType.equals(targetType);
        }

        private static final class NumberToNumberConverter<T extends Number>
        implements Converter<Number, T> {
            private final Class<T> targetType;

            public NumberToNumberConverter(Class<T> targetType) {
                Assert.notNull(targetType, "Target type must not be null");
                this.targetType = targetType;
            }

            @Override
            public T convert(Number source) {
                if (source instanceof AtomicInteger) {
                    return NumberUtils.convertNumberToTargetClass(((AtomicInteger)source).get(), this.targetType);
                }
                if (source instanceof AtomicLong) {
                    return NumberUtils.convertNumberToTargetClass(((AtomicLong)source).get(), this.targetType);
                }
                return NumberUtils.convertNumberToTargetClass(source, this.targetType);
            }
        }
    }

    static enum BigIntegerToObjectIdConverter implements Converter<BigInteger, ObjectId>
    {
        INSTANCE;


        @Override
        public ObjectId convert(BigInteger source) {
            return new ObjectId(source.toString(16));
        }
    }

    static enum ObjectIdToBigIntegerConverter implements Converter<ObjectId, BigInteger>
    {
        INSTANCE;


        @Override
        public BigInteger convert(ObjectId source) {
            return new BigInteger(source.toString(), 16);
        }
    }

    static enum StringToObjectIdConverter implements Converter<String, ObjectId>
    {
        INSTANCE;


        @Override
        public ObjectId convert(String source) {
            return StringUtils.hasText(source) ? new ObjectId(source) : null;
        }
    }

    static enum ObjectIdToStringConverter implements Converter<ObjectId, String>
    {
        INSTANCE;


        @Override
        public String convert(ObjectId id) {
            return id.toString();
        }
    }
}

