/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.QueryMapper;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;

public class UpdateMapper
extends QueryMapper {
    private final MongoConverter converter;

    public UpdateMapper(MongoConverter converter) {
        super(converter);
        this.converter = converter;
    }

    @Override
    public Document getMappedObject(Bson query, @Nullable MongoPersistentEntity<?> entity) {
        Document document = super.getMappedObject(query, entity);
        boolean hasOperators = false;
        boolean hasFields = false;
        Document set = null;
        for (String s2 : document.keySet()) {
            if (s2.startsWith("$")) {
                if (s2.equals("$set")) {
                    set = (Document)((Object)document.get((Object)s2, Document.class));
                }
                hasOperators = true;
                continue;
            }
            hasFields = true;
        }
        if (hasOperators && hasFields) {
            Document updateObject = new Document();
            Document fieldsToSet = set == null ? new Document() : set;
            for (String s3 : document.keySet()) {
                if (s3.startsWith("$")) {
                    updateObject.put(s3, document.get(s3));
                    continue;
                }
                fieldsToSet.put(s3, document.get(s3));
            }
            updateObject.put("$set", (Object)fieldsToSet);
            return updateObject;
        }
        return document;
    }

    public static boolean isUpdateObject(@Nullable Document updateObj) {
        if (updateObj == null) {
            return false;
        }
        for (String s2 : updateObj.keySet()) {
            if (!s2.startsWith("$")) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Object delegateConvertToMongoType(Object source, @Nullable MongoPersistentEntity<?> entity) {
        if (entity != null && entity.isUnwrapped()) {
            return this.converter.convertToMongoType(source, entity);
        }
        return this.converter.convertToMongoType(source, entity == null ? TypeInformation.OBJECT : this.getTypeHintForEntity(source, entity));
    }

    @Override
    protected Map.Entry<String, Object> getMappedObjectForField(QueryMapper.Field field, Object rawValue) {
        if (this.isDocument(rawValue)) {
            Object val = field.isMap() ? new LinkedHashMap<String, Object>((Document)rawValue) : rawValue;
            return this.createMapEntry(field, this.convertSimpleOrDocument(val, field.getPropertyEntity()));
        }
        if (this.isQuery(rawValue)) {
            return this.createMapEntry(field, super.getMappedObject((Bson)((Query)rawValue).getQueryObject(), field.getPropertyEntity()));
        }
        if (this.isUpdateModifier(rawValue)) {
            return this.getMappedUpdateModifier(field, rawValue);
        }
        return super.getMappedObjectForField(field, rawValue);
    }

    private Map.Entry<String, Object> getMappedUpdateModifier(QueryMapper.Field field, Object rawValue) {
        Document value = null;
        if (rawValue instanceof Update.Modifier) {
            value = this.getMappedValue(field, (Update.Modifier)rawValue);
        } else if (rawValue instanceof Update.Modifiers) {
            Document modificationOperations = new Document();
            for (Update.Modifier modifier : ((Update.Modifiers)rawValue).getModifiers()) {
                modificationOperations.putAll(this.getMappedValue(field, modifier));
            }
            value = modificationOperations;
        } else {
            throw new IllegalArgumentException(String.format("Unable to map value of type '%s'", rawValue.getClass()));
        }
        return this.createMapEntry(field, value);
    }

    @Override
    protected boolean isAssociationConversionNecessary(QueryMapper.Field documentField, @Nullable Object value) {
        return super.isAssociationConversionNecessary(documentField, value) || documentField.containsAssociation();
    }

    private boolean isUpdateModifier(@Nullable Object value) {
        return value instanceof Update.Modifier || value instanceof Update.Modifiers;
    }

    private boolean isQuery(@Nullable Object value) {
        return value instanceof Query;
    }

    private Document getMappedValue(@Nullable QueryMapper.Field field, Update.Modifier modifier) {
        return new Document(modifier.getKey(), this.getMappedModifier(field, modifier));
    }

    private Object getMappedModifier(@Nullable QueryMapper.Field field, Update.Modifier modifier) {
        Object value = modifier.getValue();
        if (value instanceof Sort) {
            Document sortObject = UpdateMapper.getSortObject((Sort)value);
            return field == null || field.getPropertyEntity() == null ? sortObject : this.getMappedSort(sortObject, field.getPropertyEntity());
        }
        if (this.isAssociationConversionNecessary(field, value)) {
            if (ObjectUtils.isArray(value) || value instanceof Collection) {
                ArrayList<Object> targetPointers = new ArrayList<Object>();
                for (Object val : this.converter.getConversionService().convert(value, List.class)) {
                    targetPointers.add(this.getMappedValue(field, val));
                }
                return targetPointers;
            }
            return super.getMappedValue(field, value);
        }
        TypeInformation<Object> typeHint = field == null ? TypeInformation.OBJECT : field.getTypeHint();
        return this.converter.convertToMongoType(value, typeHint);
    }

    private TypeInformation<?> getTypeHintForEntity(@Nullable Object source, MongoPersistentEntity<?> entity) {
        TypeInformation info = entity.getTypeInformation();
        Class<?> type = info.getActualType().getType();
        if (source == null || type.isInterface() || Modifier.isAbstract(type.getModifiers())) {
            return info;
        }
        if (source instanceof Collection) {
            return NESTED_DOCUMENT;
        }
        if (!type.equals(source.getClass())) {
            return info;
        }
        return NESTED_DOCUMENT;
    }

    @Override
    protected QueryMapper.Field createPropertyField(MongoPersistentEntity<?> entity, String key, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
        return entity == null ? super.createPropertyField(entity, key, mappingContext) : new MetadataBackedUpdateField(entity, key, mappingContext);
    }

    private static Document getSortObject(Sort sort) {
        Document document = new Document();
        for (Sort.Order order : sort) {
            document.put(order.getProperty(), (Object)(order.isAscending() ? 1 : -1));
        }
        return document;
    }

    private static class MetadataBackedUpdateField
    extends QueryMapper.MetadataBackedField {
        private final String key;

        public MetadataBackedUpdateField(MongoPersistentEntity<?> entity, String key, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
            super(key, entity, mappingContext);
            this.key = key;
        }

        @Override
        public String getMappedKey() {
            return this.getPath() == null ? this.key : super.getMappedKey();
        }

        @Override
        protected Converter<MongoPersistentProperty, String> getPropertyConverter() {
            return new QueryMapper.MetadataBackedField.PositionParameterRetainingPropertyKeyConverter(this.key, this.getMappingContext());
        }

        @Override
        protected Converter<MongoPersistentProperty, String> getAssociationConverter() {
            return new UpdateAssociationConverter(this.getMappingContext(), this.getAssociation(), this.key);
        }

        protected static class UpdateAssociationConverter
        extends QueryMapper.AssociationConverter {
            private final QueryMapper.MetadataBackedField.KeyMapper mapper;

            public UpdateAssociationConverter(MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext, Association<MongoPersistentProperty> association, String key) {
                super(key, association);
                this.mapper = new QueryMapper.MetadataBackedField.KeyMapper(key, mappingContext);
            }

            @Override
            public String convert(MongoPersistentProperty source) {
                return super.convert(source) == null ? null : this.mapper.mapPropertyName(source);
            }
        }
    }
}

