/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.geo;

import java.util.Arrays;
import java.util.List;
import org.springframework.data.annotation.PersistenceCreator;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Point;
import org.springframework.data.geo.Shape;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class Sphere
implements Shape {
    public static final String COMMAND = "$centerSphere";
    private final Point center;
    private final Distance radius;

    @PersistenceCreator
    public Sphere(Point center, Distance radius) {
        Assert.notNull((Object)center, "Center point must not be null");
        Assert.notNull((Object)radius, "Radius must not be null");
        Assert.isTrue(radius.getValue() >= 0.0, "Radius must not be negative");
        this.center = center;
        this.radius = radius;
    }

    public Sphere(Point center, double radius) {
        this(center, new Distance(radius));
    }

    public Sphere(Circle circle) {
        this(circle.getCenter(), circle.getRadius());
    }

    public Point getCenter() {
        return new Point(this.center);
    }

    public Distance getRadius() {
        return this.radius;
    }

    public String toString() {
        return String.format("Sphere [center=%s, radius=%s]", this.center, this.radius);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Sphere)) {
            return false;
        }
        Sphere that = (Sphere)obj;
        return this.center.equals(that.center) && this.radius.equals(that.radius);
    }

    public int hashCode() {
        int result = 17;
        result += 31 * this.center.hashCode();
        return result += 31 * this.radius.hashCode();
    }

    public List<? extends Object> asList() {
        return Arrays.asList(Arrays.asList(this.center.getX(), this.center.getY()), this.radius.getValue());
    }

    public String getCommand() {
        return COMMAND;
    }
}

