/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.index;

import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationListener;
import org.springframework.data.mapping.context.MappingContextEvent;
import org.springframework.data.mongodb.core.index.MongoPersistentEntityIndexCreator;
import org.springframework.util.Assert;

public class MongoMappingEventPublisher
implements ApplicationEventPublisher {
    private final ApplicationListener<MappingContextEvent<?, ?>> indexCreator;

    public MongoMappingEventPublisher(ApplicationListener<MappingContextEvent<?, ?>> indexCreator) {
        Assert.notNull(indexCreator, "ApplicationListener must not be null");
        this.indexCreator = indexCreator;
    }

    public MongoMappingEventPublisher(MongoPersistentEntityIndexCreator indexCreator) {
        Assert.notNull((Object)indexCreator, "MongoPersistentEntityIndexCreator must not be null");
        this.indexCreator = indexCreator;
    }

    @Override
    public void publishEvent(ApplicationEvent event) {
        if (event instanceof MappingContextEvent) {
            this.indexCreator.onApplicationEvent((MappingContextEvent)event);
        }
    }

    @Override
    public void publishEvent(Object event) {
    }
}

