/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.mapping.event;

import org.springframework.beans.factory.ObjectFactory;
import org.springframework.core.Ordered;
import org.springframework.data.auditing.IsNewAwareAuditingHandler;
import org.springframework.data.mongodb.core.mapping.event.BeforeConvertCallback;
import org.springframework.util.Assert;

public class AuditingEntityCallback
implements BeforeConvertCallback<Object>,
Ordered {
    private final ObjectFactory<IsNewAwareAuditingHandler> auditingHandlerFactory;

    public AuditingEntityCallback(ObjectFactory<IsNewAwareAuditingHandler> auditingHandlerFactory) {
        Assert.notNull(auditingHandlerFactory, "IsNewAwareAuditingHandler must not be null");
        this.auditingHandlerFactory = auditingHandlerFactory;
    }

    @Override
    public Object onBeforeConvert(Object entity, String collection) {
        return this.auditingHandlerFactory.getObject().markAudited(entity);
    }

    @Override
    public int getOrder() {
        return 100;
    }
}

