/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.query;

import org.bson.Document;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class BasicQuery
extends Query {
    private final Document queryObject;
    private Document fieldsObject;
    private Document sortObject;

    public BasicQuery(@Nullable String query) {
        this(query, null);
    }

    public BasicQuery(Document queryObject) {
        this(queryObject, new Document());
    }

    public BasicQuery(@Nullable String query, @Nullable String fields) {
        this(query != null ? Document.parse(query) : new Document(), fields != null ? Document.parse(fields) : new Document());
    }

    public BasicQuery(Document queryObject, Document fieldsObject) {
        Assert.notNull((Object)queryObject, "Query document must not be null");
        Assert.notNull((Object)fieldsObject, "Field document must not be null");
        this.queryObject = queryObject;
        this.fieldsObject = fieldsObject;
        this.sortObject = new Document();
    }

    @Override
    public Query addCriteria(CriteriaDefinition criteria) {
        this.queryObject.putAll(criteria.getCriteriaObject());
        return this;
    }

    @Override
    public Document getQueryObject() {
        return this.queryObject;
    }

    @Override
    public Document getFieldsObject() {
        Document combinedFieldsObject = new Document();
        combinedFieldsObject.putAll(this.fieldsObject);
        combinedFieldsObject.putAll(super.getFieldsObject());
        return combinedFieldsObject;
    }

    @Override
    public Document getSortObject() {
        Document result = new Document();
        result.putAll(this.sortObject);
        Document overrides = super.getSortObject();
        result.putAll(overrides);
        return result;
    }

    public void setSortObject(Document sortObject) {
        Assert.notNull((Object)sortObject, "Sort document must not be null");
        this.sortObject = sortObject;
    }

    @Override
    public boolean isSorted() {
        return super.isSorted() || !this.sortObject.isEmpty();
    }

    public void setFieldsObject(Document fieldsObject) {
        Assert.notNull((Object)fieldsObject, "Field document must not be null");
        this.fieldsObject = fieldsObject;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BasicQuery)) {
            return false;
        }
        BasicQuery that = (BasicQuery)o;
        return this.querySettingsEquals(that) && ObjectUtils.nullSafeEquals(this.fieldsObject, that.fieldsObject) && ObjectUtils.nullSafeEquals(this.queryObject, that.queryObject) && ObjectUtils.nullSafeEquals(this.sortObject, that.sortObject);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.queryObject);
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.fieldsObject);
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.sortObject);
        return result;
    }
}

