/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.query;

import java.util.Arrays;
import java.util.Collections;
import org.bson.Document;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.lang.Nullable;

public class BasicUpdate
extends Update {
    private Document updateObject;

    public BasicUpdate(String updateString) {
        this.updateObject = Document.parse(updateString);
    }

    public BasicUpdate(Document updateObject) {
        this.updateObject = updateObject;
    }

    @Override
    public Update set(String key, @Nullable Object value) {
        this.updateObject.put("$set", (Object)Collections.singletonMap(key, value));
        return this;
    }

    @Override
    public Update unset(String key) {
        this.updateObject.put("$unset", (Object)Collections.singletonMap(key, 1));
        return this;
    }

    @Override
    public Update inc(String key, Number inc) {
        this.updateObject.put("$inc", (Object)Collections.singletonMap(key, inc));
        return this;
    }

    @Override
    public Update push(String key, @Nullable Object value) {
        this.updateObject.put("$push", (Object)Collections.singletonMap(key, value));
        return this;
    }

    @Override
    public Update addToSet(String key, @Nullable Object value) {
        this.updateObject.put("$addToSet", (Object)Collections.singletonMap(key, value));
        return this;
    }

    @Override
    public Update pop(String key, Update.Position pos) {
        this.updateObject.put("$pop", (Object)Collections.singletonMap(key, pos == Update.Position.FIRST ? -1 : 1));
        return this;
    }

    @Override
    public Update pull(String key, @Nullable Object value) {
        this.updateObject.put("$pull", (Object)Collections.singletonMap(key, value));
        return this;
    }

    @Override
    public Update pullAll(String key, Object[] values) {
        Document keyValue = new Document();
        keyValue.put(key, (Object)Arrays.copyOf(values, values.length));
        this.updateObject.put("$pullAll", (Object)keyValue);
        return this;
    }

    @Override
    public Update rename(String oldName, String newName) {
        this.updateObject.put("$rename", (Object)Collections.singletonMap(oldName, newName));
        return this;
    }

    @Override
    public Document getUpdateObject() {
        return this.updateObject;
    }
}

