/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.query;

import org.springframework.data.geo.Box;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Polygon;
import org.springframework.data.geo.Shape;
import org.springframework.data.mongodb.core.geo.Sphere;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public final class GeoCommand {
    private final Shape shape;
    private final String command;

    public GeoCommand(Shape shape) {
        Assert.notNull((Object)shape, "Shape must not be null");
        this.shape = shape;
        this.command = this.getCommand(shape);
    }

    public Shape getShape() {
        return this.shape;
    }

    public String getCommand() {
        return this.command;
    }

    private String getCommand(Shape shape) {
        Assert.notNull((Object)shape, "Shape must not be null");
        if (shape instanceof Box) {
            return "$box";
        }
        if (shape instanceof Circle) {
            return "$center";
        }
        if (shape instanceof Polygon) {
            return "$polygon";
        }
        if (shape instanceof Sphere) {
            return "$centerSphere";
        }
        throw new IllegalArgumentException("Unknown shape: " + shape);
    }

    public int hashCode() {
        int result = 31;
        result += 17 * ObjectUtils.nullSafeHashCode(this.command);
        return result += 17 * ObjectUtils.nullSafeHashCode(this.shape);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GeoCommand)) {
            return false;
        }
        GeoCommand that = (GeoCommand)obj;
        return ObjectUtils.nullSafeEquals(this.command, that.command) && ObjectUtils.nullSafeEquals(this.shape, that.shape);
    }
}

