/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.query;

import java.time.Duration;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class Meta {
    private Map<String, Object> values = Collections.emptyMap();
    private Set<CursorOption> flags = Collections.emptySet();
    private Integer cursorBatchSize;
    private Boolean allowDiskUse;

    public Meta() {
    }

    Meta(Meta source) {
        this.values = new LinkedHashMap<String, Object>(source.values);
        this.flags = new LinkedHashSet<CursorOption>(source.flags);
        this.cursorBatchSize = source.cursorBatchSize;
        this.allowDiskUse = source.allowDiskUse;
    }

    @Nullable
    public Long getMaxTimeMsec() {
        return (Long)this.getValue(MetaKey.MAX_TIME_MS.key);
    }

    public void setMaxTimeMsec(long maxTimeMsec) {
        this.setMaxTime(Duration.ofMillis(maxTimeMsec));
    }

    public void setMaxTime(Duration timeout) {
        Assert.notNull((Object)timeout, "Timeout must not be null");
        this.setValue(MetaKey.MAX_TIME_MS.key, timeout.toMillis());
    }

    public void setComment(String comment) {
        this.setValue(MetaKey.COMMENT.key, comment);
    }

    @Nullable
    public String getComment() {
        return (String)this.getValue(MetaKey.COMMENT.key);
    }

    @Nullable
    public Integer getCursorBatchSize() {
        return this.cursorBatchSize;
    }

    public void setCursorBatchSize(int cursorBatchSize) {
        this.cursorBatchSize = cursorBatchSize;
    }

    public boolean addFlag(CursorOption option) {
        Assert.notNull((Object)option, "CursorOption must not be null");
        if (this.flags == Collections.EMPTY_SET) {
            this.flags = new LinkedHashSet<CursorOption>(2);
        }
        return this.flags.add(option);
    }

    public Set<CursorOption> getFlags() {
        return this.flags;
    }

    @Nullable
    public Boolean getAllowDiskUse() {
        return this.allowDiskUse;
    }

    public void setAllowDiskUse(@Nullable Boolean allowDiskUse) {
        this.allowDiskUse = allowDiskUse;
    }

    public boolean hasValues() {
        return !this.values.isEmpty() || !this.flags.isEmpty() || this.cursorBatchSize != null || this.allowDiskUse != null;
    }

    public Iterable<Map.Entry<String, Object>> values() {
        return Collections.unmodifiableSet(this.values.entrySet());
    }

    void setValue(String key, @Nullable Object value) {
        Assert.hasText(key, "Meta key must not be 'null' or blank");
        if (this.values == Collections.EMPTY_MAP) {
            this.values = new LinkedHashMap<String, Object>(2);
        }
        if (value == null || value instanceof String && !StringUtils.hasText((String)value)) {
            this.values.remove(key);
        }
        this.values.put(key, value);
    }

    @Nullable
    private <T> T getValue(String key) {
        return (T)this.values.get(key);
    }

    private <T> T getValue(String key, T defaultValue) {
        T value = this.getValue(key);
        return value != null ? value : defaultValue;
    }

    public int hashCode() {
        int hash = ObjectUtils.nullSafeHashCode(this.values);
        return hash += ObjectUtils.nullSafeHashCode(this.flags);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Meta)) {
            return false;
        }
        Meta other = (Meta)obj;
        if (!ObjectUtils.nullSafeEquals(this.values, other.values)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals(this.flags, other.flags);
    }

    private static enum MetaKey {
        MAX_TIME_MS("$maxTimeMS"),
        MAX_SCAN("$maxScan"),
        COMMENT("$comment"),
        SNAPSHOT("$snapshot");

        private String key;

        private MetaKey(String key) {
            this.key = key;
        }
    }

    public static enum CursorOption {
        NO_TIMEOUT,
        EXHAUST,
        SECONDARY_READS,
        PARTIAL;

    }
}

