/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.bson.Document;
import org.springframework.data.mongodb.core.schema.MongoJsonSchema;
import org.springframework.data.mongodb.core.schema.TypeUnifyingMergeFunction;

class MergedJsonSchema
implements MongoJsonSchema {
    private final List<MongoJsonSchema> schemaList;
    private final BiFunction<Map<String, Object>, Map<String, Object>, Document> mergeFunction;

    MergedJsonSchema(List<MongoJsonSchema> schemaList, MongoJsonSchema.ConflictResolutionFunction conflictResolutionFunction) {
        this(schemaList, new TypeUnifyingMergeFunction(conflictResolutionFunction));
    }

    MergedJsonSchema(List<MongoJsonSchema> schemaList, BiFunction<Map<String, Object>, Map<String, Object>, Document> mergeFunction) {
        this.schemaList = new ArrayList<MongoJsonSchema>(schemaList);
        this.mergeFunction = mergeFunction;
    }

    @Override
    public MongoJsonSchema mergeWith(Collection<MongoJsonSchema> sources) {
        this.schemaList.addAll(sources);
        return this;
    }

    @Override
    public Document schemaDocument() {
        Document targetSchema = new Document();
        for (MongoJsonSchema schema : this.schemaList) {
            targetSchema = this.mergeFunction.apply(targetSchema, schema.schemaDocument());
        }
        return targetSchema;
    }
}

