/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.bson.Document;
import org.springframework.data.mongodb.core.schema.MongoJsonSchema;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

class TypeUnifyingMergeFunction
implements BiFunction<Map<String, Object>, Map<String, Object>, Document> {
    private final MongoJsonSchema.ConflictResolutionFunction conflictResolutionFunction;

    public TypeUnifyingMergeFunction(MongoJsonSchema.ConflictResolutionFunction conflictResolutionFunction) {
        this.conflictResolutionFunction = conflictResolutionFunction;
    }

    @Override
    public Document apply(Map<String, Object> left, Map<String, Object> right) {
        return this.merge(SimplePath.root(), left, right);
    }

    Document merge(SimplePath path, Map<String, Object> left, Map<String, Object> right) {
        Document target = new Document(left);
        for (String key : right.keySet()) {
            Object unifiedExistingType;
            SimplePath currentPath = path.append(key);
            if (TypeUnifyingMergeFunction.isTypeKey(key) && (unifiedExistingType = TypeUnifyingMergeFunction.getUnifiedExistingType(key, target)) != null) {
                if (ObjectUtils.nullSafeEquals(unifiedExistingType, right.get(key))) continue;
                this.resolveConflict(currentPath, left, right, target);
                continue;
            }
            if (!target.containsKey(key)) {
                target.put(key, right.get(key));
                continue;
            }
            Object existingEntry = target.get(key);
            Object newEntry = right.get(key);
            if (existingEntry instanceof Map && newEntry instanceof Map) {
                target.put(key, (Object)this.merge(currentPath, (Map)existingEntry, (Map)newEntry));
                continue;
            }
            if (ObjectUtils.nullSafeEquals(existingEntry, newEntry)) continue;
            this.resolveConflict(currentPath, left, right, target);
        }
        return target;
    }

    private void resolveConflict(MongoJsonSchema.ConflictResolutionFunction.Path path, Map<String, Object> left, Map<String, Object> right, Document target) {
        this.applyConflictResolution(path, target, this.conflictResolutionFunction.resolveConflict(path, left, right));
    }

    private void applyConflictResolution(MongoJsonSchema.ConflictResolutionFunction.Path path, Document target, MongoJsonSchema.ConflictResolutionFunction.Resolution resolution) {
        if (MongoJsonSchema.ConflictResolutionFunction.Resolution.SKIP.equals(resolution) || resolution.getValue() == null) {
            target.remove(path.currentElement());
            return;
        }
        if (TypeUnifyingMergeFunction.isTypeKey((String)resolution.getKey())) {
            target.put(TypeUnifyingMergeFunction.getTypeKeyToUse((String)resolution.getKey(), target), resolution.getValue());
        } else {
            target.put((String)resolution.getKey(), resolution.getValue());
        }
    }

    private static boolean isTypeKey(String key) {
        return "bsonType".equals(key) || "type".equals(key);
    }

    private static String getTypeKeyToUse(String key, Document source) {
        if ("bsonType".equals(key) && source.containsKey("type")) {
            return "type";
        }
        if ("type".equals(key) && source.containsKey("bsonType")) {
            return "bsonType";
        }
        return key;
    }

    @Nullable
    private static Object getUnifiedExistingType(String key, Document source) {
        return source.get(TypeUnifyingMergeFunction.getTypeKeyToUse(key, source));
    }

    static class SimplePath
    implements MongoJsonSchema.ConflictResolutionFunction.Path {
        private final List<String> path;

        SimplePath(List<String> path) {
            this.path = path;
        }

        static SimplePath root() {
            return new SimplePath(Collections.emptyList());
        }

        static SimplePath of(List<String> path, String next) {
            ArrayList<String> fullPath = new ArrayList<String>(path.size() + 1);
            fullPath.addAll(path);
            fullPath.add(next);
            return new SimplePath(fullPath);
        }

        public SimplePath append(String next) {
            return SimplePath.of(this.path, next);
        }

        @Override
        public String currentElement() {
            return CollectionUtils.lastElement(this.path);
        }

        @Override
        public String dotPath() {
            return StringUtils.collectionToDelimitedString(this.path, ".");
        }

        public String toString() {
            return this.dotPath();
        }
    }
}

