/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.monitor;

import com.mongodb.ServerAddress;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoDatabase;
import com.mongodb.connection.ServerDescription;
import java.util.List;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.conversions.Bson;

public abstract class AbstractMonitor {
    private final MongoClient mongoClient;

    protected AbstractMonitor(MongoClient mongoClient) {
        this.mongoClient = mongoClient;
    }

    public Document getServerStatus() {
        return this.getDb("admin").runCommand((Bson)new Document("serverStatus", 1).append("rangeDeleter", 1).append("repl", 1));
    }

    public MongoDatabase getDb(String databaseName) {
        return this.mongoClient.getDatabase(databaseName);
    }

    protected MongoClient getMongoClient() {
        return this.mongoClient;
    }

    protected List<ServerAddress> hosts() {
        return this.mongoClient.getClusterDescription().getServerDescriptions().stream().map(ServerDescription::getAddress).collect(Collectors.toList());
    }
}

