/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.monitor;

import com.mongodb.client.MongoClient;
import org.bson.Document;
import org.springframework.data.mongodb.monitor.AbstractMonitor;
import org.springframework.jmx.export.annotation.ManagedMetric;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.jmx.support.MetricType;

@ManagedResource(description="Memory Metrics")
public class MemoryMetrics
extends AbstractMonitor {
    public MemoryMetrics(MongoClient mongoClient) {
        super(mongoClient);
    }

    @ManagedMetric(metricType=MetricType.COUNTER, displayName="Memory address size")
    public int getBits() {
        return this.getMemData("bits", Integer.class);
    }

    @ManagedMetric(metricType=MetricType.GAUGE, displayName="Resident in Physical Memory", unit="MB")
    public int getResidentSpace() {
        return this.getMemData("resident", Integer.class);
    }

    @ManagedMetric(metricType=MetricType.GAUGE, displayName="Virtual Address Space", unit="MB")
    public int getVirtualAddressSpace() {
        return this.getMemData("virtual", Integer.class);
    }

    @ManagedMetric(metricType=MetricType.GAUGE, displayName="Is memory info supported on this platform")
    public boolean getMemoryInfoSupported() {
        return this.getMemData("supported", Boolean.class);
    }

    @ManagedMetric(metricType=MetricType.GAUGE, displayName="Memory Mapped Space", unit="MB")
    public int getMemoryMappedSpace() {
        return this.getMemData("mapped", Integer.class);
    }

    private <T> T getMemData(String key, Class<T> targetClass) {
        Document mem = (Document)this.getServerStatus().get("mem");
        return (T)mem.get(key);
    }
}

