/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.observability;

import com.mongodb.RequestContext;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

class MapRequestContext
implements RequestContext {
    private final Map<Object, Object> map;

    public MapRequestContext() {
        this(new HashMap<Object, Object>());
    }

    public MapRequestContext(Map<Object, Object> context) {
        this.map = context;
    }

    @Override
    public <T> T get(Object key) {
        return (T)this.map.get(key);
    }

    @Override
    public boolean hasKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public void put(Object key, Object value) {
        this.map.put(key, value);
    }

    @Override
    public void delete(Object key) {
        this.map.remove(key);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Stream<Map.Entry<Object, Object>> stream() {
        return this.map.entrySet().stream();
    }
}

