/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.aot;

import org.springframework.aot.generate.GenerationContext;
import org.springframework.data.mongodb.aot.LazyLoadingProxyAotProcessor;
import org.springframework.data.mongodb.aot.MongoAotPredicates;
import org.springframework.data.repository.config.AotRepositoryContext;
import org.springframework.data.repository.config.RepositoryRegistrationAotProcessor;
import org.springframework.data.util.TypeContributor;
import org.springframework.data.util.TypeUtils;

public class AotMongoRepositoryPostProcessor
extends RepositoryRegistrationAotProcessor {
    private final LazyLoadingProxyAotProcessor lazyLoadingProxyAotProcessor = new LazyLoadingProxyAotProcessor();

    @Override
    protected void contribute(AotRepositoryContext repositoryContext, GenerationContext generationContext) {
        super.contribute(repositoryContext, generationContext);
        repositoryContext.getResolvedTypes().stream().filter(MongoAotPredicates.IS_SIMPLE_TYPE.negate()).forEach(type -> {
            TypeContributor.contribute(type, it -> true, generationContext);
            this.lazyLoadingProxyAotProcessor.registerLazyLoadingProxyIfNeeded((Class<?>)type, generationContext);
        });
    }

    @Override
    protected void contributeType(Class<?> type, GenerationContext generationContext) {
        if (TypeUtils.type(type).isPartOf("org.springframework.data.mongodb", "com.mongodb")) {
            return;
        }
        super.contributeType(type, generationContext);
    }
}

