/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bson.Document;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.data.mongodb.repository.query.ConvertingParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoParameters;
import org.springframework.data.mongodb.util.json.ParameterBindingContext;
import org.springframework.data.mongodb.util.json.ParameterBindingDocumentCodec;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.spel.ExpressionDependencies;
import org.springframework.expression.ExpressionParser;
import org.springframework.lang.Nullable;
import org.springframework.util.NumberUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

abstract class CollationUtils {
    private static final ParameterBindingDocumentCodec CODEC = new ParameterBindingDocumentCodec();
    private static final Pattern PARAMETER_BINDING_PATTERN = Pattern.compile("\\?(\\d+)");

    private CollationUtils() {
    }

    @Nullable
    static Collation computeCollation(@Nullable String collationExpression, ConvertingParameterAccessor accessor, MongoParameters parameters, ExpressionParser expressionParser, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        if (accessor.getCollation() != null) {
            return accessor.getCollation();
        }
        if (!StringUtils.hasText(collationExpression)) {
            return null;
        }
        if (collationExpression.stripLeading().startsWith("{")) {
            ParameterBindingContext bindingContext = ParameterBindingContext.forExpressions(accessor::getBindableValue, expressionParser, dependencies -> evaluationContextProvider.getEvaluationContext(parameters, accessor.getValues(), (ExpressionDependencies)dependencies));
            return Collation.from(CODEC.decode(collationExpression, bindingContext));
        }
        Matcher matcher = PARAMETER_BINDING_PATTERN.matcher(collationExpression);
        if (!matcher.find()) {
            return Collation.parse(collationExpression);
        }
        String placeholder = matcher.group();
        Object placeholderValue = accessor.getBindableValue(CollationUtils.computeParameterIndex(placeholder));
        if (collationExpression.startsWith("?")) {
            if (placeholderValue instanceof String) {
                return Collation.parse(placeholderValue.toString());
            }
            if (placeholderValue instanceof Locale) {
                return Collation.of((Locale)placeholderValue);
            }
            if (placeholderValue instanceof Document) {
                return Collation.from((Document)placeholderValue);
            }
            throw new IllegalArgumentException(String.format("Collation must be a String, Locale or Document but was %s", ObjectUtils.nullSafeClassName(placeholderValue)));
        }
        return Collation.parse(collationExpression.replace(placeholder, placeholderValue.toString()));
    }

    private static int computeParameterIndex(String parameter) {
        return NumberUtils.parseNumber(parameter.replace("?", ""), Integer.class);
    }
}

