/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.Range;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Point;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.data.mongodb.core.query.TextCriteria;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.data.mongodb.repository.Near;
import org.springframework.data.mongodb.repository.query.QueryUtils;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;

public class MongoParameters
extends Parameters<MongoParameters, MongoParameter> {
    private final int rangeIndex;
    private final int maxDistanceIndex;
    @Nullable
    private final Integer fullTextIndex;
    @Nullable
    private final Integer nearIndex;
    @Nullable
    private final Integer collationIndex;
    private final int updateIndex;

    public MongoParameters(Method method, boolean isGeoNearMethod) {
        super(method);
        List<Class<?>> parameterTypes = Arrays.asList(method.getParameterTypes());
        this.fullTextIndex = parameterTypes.indexOf(TextCriteria.class);
        TypeInformation<?> declaringClassInfo = TypeInformation.of(method.getDeclaringClass());
        List<TypeInformation<?>> parameterTypeInfo = declaringClassInfo.getParameterTypes(method);
        this.rangeIndex = this.getTypeIndex(parameterTypeInfo, Range.class, Distance.class);
        this.maxDistanceIndex = this.rangeIndex == -1 ? this.getTypeIndex(parameterTypeInfo, Distance.class, null) : -1;
        this.collationIndex = this.getTypeIndex(parameterTypeInfo, Collation.class, null);
        this.updateIndex = QueryUtils.indexOfAssignableParameter(UpdateDefinition.class, parameterTypes);
        int index = this.findNearIndexInParameters(method);
        if (index == -1 && isGeoNearMethod) {
            index = this.getNearIndex(parameterTypes);
        }
        this.nearIndex = index;
    }

    private MongoParameters(List<MongoParameter> parameters, int maxDistanceIndex, @Nullable Integer nearIndex, @Nullable Integer fullTextIndex, int rangeIndex, @Nullable Integer collationIndex, int updateIndex) {
        super(parameters);
        this.nearIndex = nearIndex;
        this.fullTextIndex = fullTextIndex;
        this.maxDistanceIndex = maxDistanceIndex;
        this.rangeIndex = rangeIndex;
        this.collationIndex = collationIndex;
        this.updateIndex = updateIndex;
    }

    private final int getNearIndex(List<Class<?>> parameterTypes) {
        for (Class reference : Arrays.asList(Point.class, double[].class)) {
            int nearIndex = parameterTypes.indexOf(reference);
            if (nearIndex == -1) continue;
            if (nearIndex == parameterTypes.lastIndexOf(reference)) {
                return nearIndex;
            }
            throw new IllegalStateException("Multiple Point parameters found but none annotated with @Near");
        }
        return -1;
    }

    private int findNearIndexInParameters(Method method) {
        int index = -1;
        for (java.lang.reflect.Parameter p : method.getParameters()) {
            MongoParameter param = this.createParameter(MethodParameter.forParameter(p));
            if (!param.isManuallyAnnotatedNearParameter()) continue;
            if (index == -1) {
                index = param.getIndex();
                continue;
            }
            throw new IllegalStateException(String.format("Found multiple @Near annotations ond method %s; Only one allowed", method.toString()));
        }
        return index;
    }

    @Override
    protected MongoParameter createParameter(MethodParameter parameter) {
        return new MongoParameter(parameter);
    }

    public int getDistanceRangeIndex() {
        return -1;
    }

    public int getMaxDistanceIndex() {
        return this.maxDistanceIndex;
    }

    public int getNearIndex() {
        return this.nearIndex;
    }

    public int getFullTextParameterIndex() {
        return this.fullTextIndex != null ? this.fullTextIndex : -1;
    }

    public boolean hasFullTextParameter() {
        return this.fullTextIndex != null && this.fullTextIndex >= 0;
    }

    public int getRangeIndex() {
        return this.rangeIndex;
    }

    public int getCollationParameterIndex() {
        return this.collationIndex != null ? this.collationIndex : -1;
    }

    public int getUpdateIndex() {
        return this.updateIndex;
    }

    @Override
    protected MongoParameters createFrom(List<MongoParameter> parameters) {
        return new MongoParameters(parameters, this.maxDistanceIndex, this.nearIndex, this.fullTextIndex, this.rangeIndex, this.collationIndex, this.updateIndex);
    }

    private int getTypeIndex(List<TypeInformation<?>> parameterTypes, Class<?> type, @Nullable Class<?> componentType) {
        for (int i = 0; i < parameterTypes.size(); ++i) {
            TypeInformation<?> candidate = parameterTypes.get(i);
            if (!candidate.getType().equals(type)) continue;
            if (componentType == null) {
                return i;
            }
            if (!componentType.equals(candidate.getRequiredComponentType().getType())) continue;
            return i;
        }
        return -1;
    }

    class MongoParameter
    extends Parameter {
        private final MethodParameter parameter;

        MongoParameter(MethodParameter parameter) {
            super(parameter);
            this.parameter = parameter;
            if (!this.isPoint() && this.hasNearAnnotation()) {
                throw new IllegalArgumentException("Near annotation is only allowed at Point parameter");
            }
        }

        @Override
        public boolean isSpecialParameter() {
            return super.isSpecialParameter() || Distance.class.isAssignableFrom(this.getType()) || this.isNearParameter() || TextCriteria.class.isAssignableFrom(this.getType()) || Collation.class.isAssignableFrom(this.getType());
        }

        private boolean isNearParameter() {
            Integer nearIndex = MongoParameters.this.nearIndex;
            return nearIndex != null && nearIndex.equals(this.getIndex());
        }

        private boolean isManuallyAnnotatedNearParameter() {
            return this.isPoint() && this.hasNearAnnotation();
        }

        private boolean isPoint() {
            return Point.class.isAssignableFrom(this.getType()) || this.getType().equals(double[].class);
        }

        private boolean hasNearAnnotation() {
            return this.parameter.getParameterAnnotation(Near.class) != null;
        }
    }
}

