/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import java.util.Arrays;
import java.util.List;
import org.bson.Document;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.query.CollationUtils;
import org.springframework.data.mongodb.repository.query.ConvertingParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoParameters;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.expression.ExpressionParser;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

class QueryUtils {
    QueryUtils() {
    }

    static Query decorateSort(Query query, Document defaultSort) {
        if (defaultSort.isEmpty()) {
            return query;
        }
        ProxyFactory factory = new ProxyFactory(query);
        factory.addAdvice(invocation -> {
            if (!invocation.getMethod().getName().equals("getSortObject")) {
                return invocation.proceed();
            }
            Document combinedSort = new Document(defaultSort);
            combinedSort.putAll((Document)invocation.proceed());
            return combinedSort;
        });
        return (Query)factory.getProxy(query.getClass().getClassLoader());
    }

    static Query applyCollation(Query query, @Nullable String collationExpression, ConvertingParameterAccessor accessor, MongoParameters parameters, ExpressionParser expressionParser, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        Collation collation = CollationUtils.computeCollation(collationExpression, accessor, parameters, expressionParser, evaluationContextProvider);
        return collation == null ? query : query.collation(collation);
    }

    static int indexOfAssignableParameter(Class<?> type, Class<?>[] parameters) {
        return QueryUtils.indexOfAssignableParameter(type, Arrays.asList(parameters));
    }

    static int indexOfAssignableParameter(Class<?> type, List<Class<?>> parameters) {
        if (parameters.isEmpty()) {
            return -1;
        }
        int i = 0;
        for (Class<?> parameterType : parameters) {
            if (ClassUtils.isAssignable(type, parameterType)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

