/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.data.mongodb.repository.query.MongoParametersParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoQueryMethod;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.util.ReactiveWrapperConverters;
import org.springframework.data.util.ReactiveWrappers;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class ReactiveMongoParameterAccessor
extends MongoParametersParameterAccessor {
    private final Object[] values;

    public ReactiveMongoParameterAccessor(MongoQueryMethod method, Object[] values) {
        super(method, values);
        this.values = values;
    }

    @Override
    public Object[] getValues() {
        Object[] result = new Object[super.getValues().length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.getValue(i);
        }
        return result;
    }

    @Override
    public Object getBindableValue(int index) {
        return this.getValue(((Parameter)this.getParameters().getBindableParameter(index)).getIndex());
    }

    public Mono<ReactiveMongoParameterAccessor> resolveParameters() {
        boolean hasReactiveWrapper = false;
        for (Object value : this.values) {
            if (value == null || !ReactiveWrappers.supports(value.getClass())) continue;
            hasReactiveWrapper = true;
            break;
        }
        if (!hasReactiveWrapper) {
            return Mono.just((Object)this);
        }
        Object[] resolved = new Object[this.values.length];
        ConcurrentHashMap holder = new ConcurrentHashMap();
        ArrayList<Mono> publishers = new ArrayList<Mono>();
        for (int i = 0; i < this.values.length; ++i) {
            int index;
            resolved[i] = this.values[i];
            Object value = resolved[i];
            if (value == null || !ReactiveWrappers.supports(value.getClass())) continue;
            if (ReactiveWrappers.isSingleValueType(value.getClass())) {
                index = i;
                publishers.add(ReactiveWrapperConverters.toWrapper(value, Mono.class).map(Optional::of).defaultIfEmpty(Optional.empty()).doOnNext(it -> holder.put(index, (Optional)it)));
                continue;
            }
            index = i;
            publishers.add(ReactiveWrapperConverters.toWrapper(value, Flux.class).collectList().doOnNext(it -> holder.put(index, Optional.of(it))));
        }
        return Flux.merge(publishers).then().thenReturn((Object)resolved).map(values -> {
            holder.forEach((? super K index, ? super V v) -> {
                values[index.intValue()] = v.orElse(null);
            });
            return new ReactiveMongoParameterAccessor(this.method, (Object[])values);
        });
    }
}

