/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import java.lang.reflect.Method;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.Sort;
import org.springframework.data.geo.GeoResult;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.repository.query.MongoParameters;
import org.springframework.data.mongodb.repository.query.MongoQueryMethod;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.util.ReactiveWrapperConverters;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.ReactiveWrappers;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.ClassUtils;

public class ReactiveMongoQueryMethod
extends MongoQueryMethod {
    private static final TypeInformation<Page> PAGE_TYPE = TypeInformation.of(Page.class);
    private static final TypeInformation<Slice> SLICE_TYPE = TypeInformation.of(Slice.class);
    private final Method method;
    private final Lazy<Boolean> isCollectionQuery;

    public ReactiveMongoQueryMethod(Method method, RepositoryMetadata metadata, ProjectionFactory projectionFactory, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
        super(method, metadata, projectionFactory, mappingContext);
        this.method = method;
        this.isCollectionQuery = Lazy.of(() -> !this.isPageQuery() && !this.isSliceQuery() && ReactiveWrappers.isMultiValueType(metadata.getReturnType(method).getType()) || super.isCollectionQuery());
    }

    @Override
    protected MongoParameters createParameters(Method method) {
        return new MongoParameters(method, this.isGeoNearQuery(method));
    }

    @Override
    public boolean isCollectionQuery() {
        return this.isCollectionQuery.get();
    }

    @Override
    public boolean isGeoNearQuery() {
        return this.isGeoNearQuery(this.method);
    }

    private boolean isGeoNearQuery(Method method) {
        if (ReactiveWrappers.supports(method.getReturnType())) {
            TypeInformation<?> from = TypeInformation.fromReturnTypeOf(method);
            return GeoResult.class.equals(from.getRequiredComponentType().getType());
        }
        return false;
    }

    @Override
    public boolean isModifyingQuery() {
        return super.isModifyingQuery();
    }

    @Override
    public boolean isQueryForEntity() {
        return super.isQueryForEntity();
    }

    @Override
    public boolean isStreamQuery() {
        return true;
    }

    public boolean hasReactiveWrapperParameter() {
        for (MongoParameters.MongoParameter mongoParameter : this.getParameters()) {
            if (!ReactiveWrapperConverters.supports(mongoParameter.getType())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void verify() {
        if (org.springframework.data.repository.util.ClassUtils.hasParameterOfType(this.method, Pageable.class)) {
            boolean singleWrapperWithWrappedPageableResult;
            TypeInformation<?> returnType = TypeInformation.fromReturnTypeOf(this.method);
            boolean multiWrapper = ReactiveWrappers.isMultiValueType(returnType.getType());
            boolean bl = singleWrapperWithWrappedPageableResult = ReactiveWrappers.isSingleValueType(returnType.getType()) && (PAGE_TYPE.isAssignableFrom(returnType.getRequiredComponentType()) || SLICE_TYPE.isAssignableFrom(returnType.getRequiredComponentType()));
            if (singleWrapperWithWrappedPageableResult) {
                throw new InvalidDataAccessApiUsageException(String.format("'%s.%s' must not use sliced or paged execution; Please use Flux.buffer(size, skip).", ClassUtils.getShortName(this.method.getDeclaringClass()), this.method.getName()));
            }
            if (!multiWrapper) {
                throw new IllegalStateException(String.format("Method has to use a either multi-item reactive wrapper return type or a wrapped Page/Slice type; Offending method: %s", this.method.toString()));
            }
            if (org.springframework.data.repository.util.ClassUtils.hasParameterOfType(this.method, Sort.class)) {
                throw new IllegalStateException(String.format("Method must not have Pageable *and* Sort parameter; Use sorting capabilities on Pageable instead; Offending method: %s", this.method));
            }
        }
        super.verify();
    }
}

