/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.Document;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.repository.Query;
import org.springframework.data.mongodb.repository.query.AbstractMongoQuery;
import org.springframework.data.mongodb.repository.query.BooleanUtil;
import org.springframework.data.mongodb.repository.query.ConvertingParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoQueryMethod;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.expression.ExpressionParser;
import org.springframework.util.Assert;

public class StringBasedMongoQuery
extends AbstractMongoQuery {
    private static final String COUNT_EXISTS_AND_DELETE = "Manually defined query for %s cannot be a count and exists or delete query at the same time";
    private static final Log LOG = LogFactory.getLog(StringBasedMongoQuery.class);
    private final String query;
    private final String fieldSpec;
    private final boolean isCountQuery;
    private final boolean isExistsQuery;
    private final boolean isDeleteQuery;

    public StringBasedMongoQuery(MongoQueryMethod method, MongoOperations mongoOperations, ExpressionParser expressionParser, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        this(method.getAnnotatedQuery(), method, mongoOperations, expressionParser, evaluationContextProvider);
    }

    public StringBasedMongoQuery(String query, MongoQueryMethod method, MongoOperations mongoOperations, ExpressionParser expressionParser, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        super(method, mongoOperations, expressionParser, evaluationContextProvider);
        Assert.notNull((Object)query, "Query must not be null");
        Assert.notNull((Object)expressionParser, "SpelExpressionParser must not be null");
        this.query = query;
        this.fieldSpec = method.getFieldSpecification();
        if (method.hasAnnotatedQuery()) {
            Query queryAnnotation = method.getQueryAnnotation();
            this.isCountQuery = queryAnnotation.count();
            this.isExistsQuery = queryAnnotation.exists();
            this.isDeleteQuery = queryAnnotation.delete();
            if (StringBasedMongoQuery.hasAmbiguousProjectionFlags(this.isCountQuery, this.isExistsQuery, this.isDeleteQuery)) {
                throw new IllegalArgumentException(String.format(COUNT_EXISTS_AND_DELETE, method));
            }
        } else {
            this.isCountQuery = false;
            this.isExistsQuery = false;
            this.isDeleteQuery = false;
        }
    }

    @Override
    protected org.springframework.data.mongodb.core.query.Query createQuery(ConvertingParameterAccessor accessor) {
        Document queryObject = this.decode(this.query, this.prepareBindingContext(this.query, accessor));
        Document fieldsObject = this.decode(this.fieldSpec, this.prepareBindingContext(this.fieldSpec, accessor));
        org.springframework.data.mongodb.core.query.Query query = new BasicQuery(queryObject, fieldsObject).with(accessor.getSort());
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Created query %s for %s fields.", query.getQueryObject(), query.getFieldsObject()));
        }
        return query;
    }

    @Override
    protected boolean isCountQuery() {
        return this.isCountQuery;
    }

    @Override
    protected boolean isExistsQuery() {
        return this.isExistsQuery;
    }

    @Override
    protected boolean isDeleteQuery() {
        return this.isDeleteQuery;
    }

    @Override
    protected boolean isLimiting() {
        return false;
    }

    private static boolean hasAmbiguousProjectionFlags(boolean isCountQuery, boolean isExistsQuery, boolean isDeleteQuery) {
        return BooleanUtil.countBooleanTrueValues(isCountQuery, isExistsQuery, isDeleteQuery) > 1;
    }
}

