/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.support;

import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

abstract class ReactivePageableExecutionUtils {
    private ReactivePageableExecutionUtils() {
    }

    public static <T> Mono<Page<T>> getPage(List<T> content, Pageable pageable, Mono<Long> totalSupplier) {
        Assert.notNull(content, "Content must not be null");
        Assert.notNull((Object)pageable, "Pageable must not be null");
        Assert.notNull(totalSupplier, "TotalSupplier must not be null");
        if (pageable.isUnpaged() || pageable.getOffset() == 0L) {
            if (pageable.isUnpaged() || pageable.getPageSize() > content.size()) {
                return Mono.just(new PageImpl<T>(content, pageable, content.size()));
            }
            return totalSupplier.map(total -> new PageImpl(content, pageable, (long)total));
        }
        if (content.size() != 0 && pageable.getPageSize() > content.size()) {
            return Mono.just(new PageImpl<T>(content, pageable, pageable.getOffset() + (long)content.size()));
        }
        return totalSupplier.map(total -> new PageImpl(content, pageable, (long)total));
    }
}

