/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.util;

import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class DotPath {
    private static final DotPath EMPTY = new DotPath("");
    private final String path;

    private DotPath(String path) {
        this.path = path;
    }

    public static DotPath from(@Nullable String dotPath) {
        if (StringUtils.hasLength(dotPath)) {
            return new DotPath(dotPath);
        }
        return EMPTY;
    }

    public static DotPath empty() {
        return EMPTY;
    }

    public DotPath append(String segment) {
        if (this.isEmpty()) {
            return new DotPath(segment);
        }
        return new DotPath(this.path + "." + segment);
    }

    public boolean isEmpty() {
        return !StringUtils.hasLength(this.path);
    }

    public String toString() {
        return this.path;
    }
}

