/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.util.json;

import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import org.springframework.data.mapping.model.SpELExpressionEvaluator;
import org.springframework.data.mongodb.util.json.ValueProvider;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.lang.Nullable;

class EvaluationContextExpressionEvaluator
implements SpELExpressionEvaluator {
    ValueProvider valueProvider;
    ExpressionParser expressionParser;
    Supplier<EvaluationContext> evaluationContext;

    public EvaluationContextExpressionEvaluator(ValueProvider valueProvider, ExpressionParser expressionParser, Supplier<EvaluationContext> evaluationContext) {
        this.valueProvider = valueProvider;
        this.expressionParser = expressionParser;
        this.evaluationContext = evaluationContext;
    }

    @Override
    @Nullable
    public <T> T evaluate(String expression) {
        return this.evaluateExpression(expression, Collections.emptyMap());
    }

    public EvaluationContext getEvaluationContext(String expressionString) {
        return this.evaluationContext != null ? this.evaluationContext.get() : new StandardEvaluationContext();
    }

    public SpelExpression getParsedExpression(String expressionString) {
        return (SpelExpression)(this.expressionParser != null ? this.expressionParser : new SpelExpressionParser()).parseExpression(expressionString);
    }

    public <T> T evaluateExpression(String expressionString, Map<String, Object> variables) {
        SpelExpression expression = this.getParsedExpression(expressionString);
        EvaluationContext ctx = this.getEvaluationContext(expressionString);
        variables.entrySet().forEach(entry -> ctx.setVariable((String)entry.getKey(), entry.getValue()));
        Object result = expression.getValue(ctx, Object.class);
        return (T)result;
    }
}

