/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.util.json;

import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.data.mapping.model.SpELExpressionEvaluator;
import org.springframework.data.mongodb.util.json.EvaluationContextExpressionEvaluator;
import org.springframework.data.mongodb.util.json.ValueProvider;
import org.springframework.data.spel.ExpressionDependencies;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.lang.Nullable;

public class ParameterBindingContext {
    private final ValueProvider valueProvider;
    private final SpELExpressionEvaluator expressionEvaluator;

    public ParameterBindingContext(ValueProvider valueProvider, SpelExpressionParser expressionParser, EvaluationContext evaluationContext) {
        this(valueProvider, (ExpressionParser)expressionParser, () -> evaluationContext);
    }

    public ParameterBindingContext(ValueProvider valueProvider, ExpressionParser expressionParser, Supplier<EvaluationContext> evaluationContext) {
        this(valueProvider, new EvaluationContextExpressionEvaluator(valueProvider, expressionParser, evaluationContext));
    }

    public ParameterBindingContext(ValueProvider valueProvider, SpELExpressionEvaluator expressionEvaluator) {
        this.valueProvider = valueProvider;
        this.expressionEvaluator = expressionEvaluator;
    }

    public static ParameterBindingContext forExpressions(ValueProvider valueProvider, ExpressionParser expressionParser, final Function<ExpressionDependencies, EvaluationContext> contextFunction) {
        return new ParameterBindingContext(valueProvider, new EvaluationContextExpressionEvaluator(valueProvider, expressionParser, null){

            @Override
            public EvaluationContext getEvaluationContext(String expressionString) {
                SpelExpression expression = this.getParsedExpression(expressionString);
                ExpressionDependencies dependencies = ExpressionDependencies.discover(expression);
                return (EvaluationContext)contextFunction.apply(dependencies);
            }
        });
    }

    @Nullable
    public Object bindableValueForIndex(int index) {
        return this.valueProvider.getBindableValue(index);
    }

    @Nullable
    public Object evaluateExpression(String expressionString) {
        return this.expressionEvaluator.evaluate(expressionString);
    }

    @Nullable
    public Object evaluateExpression(String expressionString, Map<String, Object> variables) {
        if (this.expressionEvaluator instanceof EvaluationContextExpressionEvaluator) {
            return ((EvaluationContextExpressionEvaluator)this.expressionEvaluator).evaluateExpression(expressionString, variables);
        }
        return this.expressionEvaluator.evaluate(expressionString);
    }

    public ValueProvider getValueProvider() {
        return this.valueProvider;
    }
}

