/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.util.spel;

import java.util.function.Supplier;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public final class ExpressionUtils {
    private static final SpelExpressionParser PARSER = new SpelExpressionParser();

    @Nullable
    public static Expression detectExpression(@Nullable String potentialExpression) {
        if (!StringUtils.hasText(potentialExpression)) {
            return null;
        }
        Expression expression = PARSER.parseExpression(potentialExpression, ParserContext.TEMPLATE_EXPRESSION);
        return expression instanceof LiteralExpression ? null : expression;
    }

    @Nullable
    public static Object evaluate(String value, Supplier<EvaluationContext> evaluationContext) {
        Expression expression = ExpressionUtils.detectExpression(value);
        if (expression == null) {
            return value;
        }
        return expression.getValue(evaluationContext.get(), Object.class);
    }
}

