/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.reactive;

import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.scope.ScopedObject;
import org.springframework.core.InfrastructureProxy;
import org.springframework.transaction.reactive.TransactionSynchronization;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

abstract class TransactionSynchronizationUtils {
    private static final Log logger = LogFactory.getLog(TransactionSynchronizationUtils.class);
    private static final boolean aopAvailable = ClassUtils.isPresent("org.springframework.aop.scope.ScopedObject", TransactionSynchronizationUtils.class.getClassLoader());

    TransactionSynchronizationUtils() {
    }

    static Object unwrapResourceIfNecessary(Object resource) {
        Assert.notNull(resource, "Resource must not be null");
        Object resourceRef = resource;
        if (resourceRef instanceof InfrastructureProxy) {
            InfrastructureProxy infrastructureProxy = (InfrastructureProxy)resourceRef;
            resourceRef = infrastructureProxy.getWrappedObject();
        }
        if (aopAvailable) {
            resourceRef = ScopedProxyUnwrapper.unwrapIfNecessary(resourceRef);
        }
        return resourceRef;
    }

    public static Mono<Void> triggerBeforeCommit(Collection<TransactionSynchronization> synchronizations, boolean readOnly) {
        return Flux.fromIterable(synchronizations).concatMap(it -> it.beforeCommit(readOnly)).then();
    }

    public static Mono<Void> triggerBeforeCompletion(Collection<TransactionSynchronization> synchronizations) {
        return Flux.fromIterable(synchronizations).concatMap(TransactionSynchronization::beforeCompletion).onErrorContinue((t, o) -> logger.debug("TransactionSynchronization.beforeCompletion threw exception", (Throwable)t)).then();
    }

    public static Mono<Void> invokeAfterCommit(Collection<TransactionSynchronization> synchronizations) {
        return Flux.fromIterable(synchronizations).concatMap(TransactionSynchronization::afterCommit).then();
    }

    public static Mono<Void> invokeAfterCompletion(Collection<TransactionSynchronization> synchronizations, int completionStatus) {
        return Flux.fromIterable(synchronizations).concatMap(it -> it.afterCompletion(completionStatus)).onErrorContinue((t, o) -> logger.debug("TransactionSynchronization.afterCompletion threw exception", (Throwable)t)).then();
    }

    private static class ScopedProxyUnwrapper {
        private ScopedProxyUnwrapper() {
        }

        public static Object unwrapIfNecessary(Object resource) {
            if (resource instanceof ScopedObject) {
                ScopedObject scopedObject = (ScopedObject)resource;
                return scopedObject.getTargetObject();
            }
            return resource;
        }
    }
}

