package app.pivo.android.lightsdk.command

import app.pivo.android.lightsdk.model.Brightness
import app.pivo.android.lightsdk.model.LightPattern

/**
 * Created by murodjon on 2021/08/27
 */
internal interface CommandGenerator {
    fun getDeviceInfoBytes(): ByteArray

    fun getBatteryLevelBytes(): ByteArray

    fun getChangeNameBytes(name: String): ByteArray?

    fun getMacAddressBytes(): ByteArray

    fun getSerialNumberBytes(): ByteArray

    fun getStopLightPresetBytes(): ByteArray

    fun getRunLightPresetBytes(
        brightness: Brightness,
        interval: Double,
        patternType: LightPattern
    ): ByteArray?

    fun getBrightnessLevelBytes(): ByteArray

    fun getTurnOffLightBytes(): ByteArray

    fun getTurnOnLightBytes(bright: Brightness): ByteArray?

    fun getDimSmoothlyBytes(bright: Brightness): ByteArray?

    fun getFlash1XBytes(bright: Brightness): ByteArray?
}