package app.pivo.android.lightsdk.controller.light

import app.pivo.android.lightsdk.model.LightDevice
import app.pivo.android.lightsdk.model.Brightness
import app.pivo.android.lightsdk.model.LightPattern

/**
 * Created by murodjon on 2021/08/27
 */
interface LightController {
    /**
     * This function is used to scan for PodX
     */
    fun scan()

    /**
     * This function is used to connect to the device.
     * @param device is the LightDevice, you want to connect to
     */
    fun connectTo(device: LightDevice)

    /**
     * Call this function to stop scanning
     */
    fun stopScan()

    /**
     * Call this function to disconnect
     */
    fun disconnect()

    /**
     * This function is used to check if the device is connected to headset
     */
    fun isConnected(): Boolean

    /**
     * This function is used to get name
     */
    fun getName(): String?

    /**
     * This function is used to change PodX name
     * @param name is desired
     */
    fun changeName(name: String)

    /**
     * This function is used to get device info
     */
    fun getDeviceInfo()

    /**
     * This function is used to request battery
     */
    fun requestBatteryLevel()

    /**
     * This functions is used request macAddress of headset
     */
    fun requestMacAddress()

    /**
     * This function is used to request serial number of headset
     */
    fun requestSerialNumber()

    /**
     * This function is used to stop light preset
     */
    fun stopLightPreset()

    /**
     * This function is used to run light preset
     */
    fun runLightPreset(
        brightness: Brightness,
        interval: Double,
        patternType: LightPattern
    )

    /**
     * This [getBrightnessLevel] function is used to get brightness level
     */
    fun getBrightnessLevel()

    /**
     * This [turnOffLight] function is used to turn off light
     */
    fun turnOffLight()

    /**
     * This [turnOnLight] function is used to turn on light
     * @param brightLevel is used to set brightness level in percentage
     */
    fun turnOnLight(brightness: Brightness)

    /**
     * This function [dimSmoothly] is used to dim smoothly
     * @param brightLevel is used to set brightness level in per.
     */
    fun dimSmoothly(brightness: Brightness)

    /**
     * This function [flash1X] function is used to flash
     * @param brightLevel is used to set brightness level in per.
     */
    fun flash1X(brightness: Brightness)
}