package app.pivo.android.lightsdk.reply.impl

import app.pivo.android.lightsdk.model.Brightness
import app.pivo.android.lightsdk.reply.Reply

/**
 * Created by murodjon on 2021/08/29
 */
class GetBrightnessReply(val bytes: ByteArray) : Reply<Brightness> {
    override fun getData(): Brightness? {
        return if (isGetBrightnessReply(bytes)) {
            Brightness(bytes[4].toInt(), bytes[5].toInt())
        } else {
            null
        }
    }

    companion object {
        fun isGetBrightnessReply(bytes: ByteArray) = bytes.size >= 6 && bytes[2] == 0x24.toByte()
    }
}