package app.pivo.android.lightsdk.reply.impl

import app.pivo.android.lightsdk.model.LightOn
import app.pivo.android.lightsdk.reply.Reply

/**
 * Created by murodjon on 2021/08/29
 */
class LightOnReply(private val bytes: ByteArray) : Reply<LightOn> {
    override fun getData(): LightOn? {
        return if (isLightOnReply(bytes)) {
            LightOn(bytes[4].toInt(), bytes[5].toInt())
        } else {
            null
        }
    }

    companion object {
        fun isLightOnReply(bytes: ByteArray) = bytes.size >= 6 && bytes[2] == 0x21.toByte()
    }
}