package app.pivo.android.lightsdk.reply.impl

import app.pivo.android.lightsdk.model.Name
import app.pivo.android.lightsdk.reply.Reply
import app.pivo.android.lightsdk.util.HexUtil

/**
 * Created by murodjon on 2021/08/29
 */
class NameChangedReply(private val bytes: ByteArray) : Reply<Name> {
    override fun getData() = getName()?.let { Name(it) }

    private fun getName(): String? {
        return if (isNameChangedReply(bytes)) {
            HexUtil.convertHexToText(bytes.copyOfRange(5, bytes.size))
        } else null
    }

    companion object {
        fun isNameChangedReply(bytes: ByteArray) =
            bytes.size >= 6
                    && bytes[2] == 0x7F.toByte()

    }
}