package app.pivo.android.lightsdk.util

import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.async
import kotlinx.coroutines.delay
import kotlinx.coroutines.isActive

/**
 * Created by murodjon on 2022/01/04
 */
fun CoroutineScope.launchPeriodicAsync(repeatMillis: Long, action: () -> Unit) =
    this.async {
        while (isActive) {
            delay(repeatMillis)
            action()
        }
    }