package app.pivo.android.lightsdk.reply

import app.pivo.android.lightsdk.reply.impl.*
import app.pivo.android.lightsdk.reply.impl.BatteryReply
import app.pivo.android.lightsdk.reply.impl.DeviceInfoReply

/**
 * Created by murodjon on 2021/08/29
 */
internal object ReplyUtil {
    fun getType(bytes: ByteArray): Reply<*> {
        return when {
            DeviceInfoReply.isDeviceInfoReply(bytes) -> DeviceInfoReply(bytes)
            BatteryReply.isBatteryReply(bytes) -> BatteryReply(bytes)
            MacAddressReply.isMacAddressReply(bytes) -> MacAddressReply(bytes)
            SerialNumberReply.isSerialNumberReply(bytes) -> SerialNumberReply(bytes)
            NameChangedReply.isNameChangedReply(bytes) -> NameChangedReply(bytes)
            StopPresetReply.isStopPresetReply(bytes) -> StopPresetReply(bytes)
            RunPresetReply.isRunPresetReply(bytes) -> RunPresetReply(bytes)
            LightOffReply.isLightOffReply(bytes) -> LightOffReply(bytes)
            LightOnReply.isLightOnReply(bytes) -> LightOnReply(bytes)
            FlashReply.isFlashReply(bytes) -> FlashReply(bytes)
            SmoothDimReply.isSmoothDimReply(bytes) -> SmoothDimReply(bytes)
            GetBrightnessReply.isGetBrightnessReply(bytes) -> GetBrightnessReply(bytes)
            else -> InvalidBytesReply()
        }
    }
}