package app.pivo.android.lightsdk.reply.impl

import app.pivo.android.lightsdk.events.LightModel
import app.pivo.android.lightsdk.model.DeviceInfo
import app.pivo.android.lightsdk.reply.Reply

/**
 * Created by murodjon on 2021/08/29
 */
internal class DeviceInfoReply constructor(private val bytes: ByteArray) : Reply<DeviceInfo> {

    override fun getData(): DeviceInfo {
        val model = when (bytes[4]) {
            0xB1.toByte() -> LightModel.PIVO_LIGHT
            else -> LightModel.OTHER
        }
        return DeviceInfo(model, bytes[5].toInt())
    }

    companion object {
        fun isDeviceInfoReply(bytes: ByteArray) =
            bytes.size >= 6 && bytes[2] == 0x03.toByte()
    }
}