package app.pivo.android.lightsdk.reply.impl

import app.pivo.android.lightsdk.model.SmoothDim
import app.pivo.android.lightsdk.reply.Reply

/**
 * Created by murodjon on 2021/08/29
 */
class SmoothDimReply(private val bytes: ByteArray) : Reply<SmoothDim> {
    override fun getData(): SmoothDim? {
        return if (isSmoothDimReply(bytes)) {
            SmoothDim(bytes[4].toInt(), bytes[5].toInt())
        } else {
            null
        }
    }

    companion object {
        fun isSmoothDimReply(bytes: ByteArray) = bytes.size >= 6 && bytes[2] == 0x23.toByte()
    }
}