package app.pivo.android.ndisdk.util

import android.Manifest
import android.content.Context
import android.content.pm.PackageManager
import android.media.AudioFormat
import android.media.AudioRecord
import android.media.MediaRecorder
import androidx.core.app.ActivityCompat


/**
 *  Created by Tom Kim.
 *  Copyright (c) 2022 3i Inc. All rights reserved.
 */
class NDIAudioRecord(context:Context):AudioRecord(
    MediaRecorder.AudioSource.DEFAULT,
    NDI_AUDIO_SAMPLE_RATE,
    AudioFormat.CHANNEL_IN_MONO,
    AudioFormat.ENCODING_PCM_FLOAT,
    getMinBufferSize(NDI_AUDIO_SAMPLE_RATE, NDI_AUDIO_CHANNEL, NDI_AUDIO_FORMAT)
){

    companion object {
        const val NDI_AUDIO_SAMPLE_RATE = 16000
        const val NDI_AUDIO_CHANNEL = AudioFormat.CHANNEL_IN_MONO
        const val NDI_AUDIO_FORMAT = AudioFormat.ENCODING_PCM_FLOAT
    }

    /**
     * initialize AudioRecording
     */
    init {
        if (ActivityCompat.checkSelfPermission(
                context,
                Manifest.permission.RECORD_AUDIO
            ) != PackageManager.PERMISSION_GRANTED
        ) {
            throw SecurityException("Manifest.permission.RECORD_AUDIO is not granted.")
        }
    }
}
