package app.pivo.android.plussdk;

import android.graphics.Rect;
import android.media.Image;

import app.pivo.android.plussdk.tracking.FrameMetadata;
import app.pivo.android.plussdk.util.ITrackingListener;

/**
 * Created by murodjon on 2020/04/16
 */
interface IFrameProcessingTask {

    void update(Image image, FrameMetadata metadata);

    void update(byte[] image, FrameMetadata metadata);

    void startPersonTracking(FrameMetadata frameMetadata, Image image, ITrackingListener listener);
    void startHorseTracking(FrameMetadata frameMetadata, Image image, ITrackingListener listener);
    void startFaceTracking(FrameMetadata frameMetadata, Image image, ITrackingListener listener);
    void startDogTracking(FrameMetadata frameMetadata, Image image, ITrackingListener listener);
    void startActionTracking(FrameMetadata frameMetadata, Rect region, Image image, ITrackingListener listener);


    void startPersonTracking(FrameMetadata frameMetadata, byte[] image, ITrackingListener listener);
    void startHorseTracking(FrameMetadata frameMetadata, byte[] image, ITrackingListener listener);
    void startFaceTracking(FrameMetadata frameMetadata, byte[] image, ITrackingListener listener);
    void startDogTracking(FrameMetadata frameMetadata, byte[] image, ITrackingListener listener);
    void startActionTracking(FrameMetadata frameMetadata, Rect region, byte[] image, ITrackingListener listener);


    void stopTracking();
    Boolean isTrackingOn();

    void setTargetToTrack(Rect rect);

    MultiBoxTracker getTracker();
}
