package app.pivo.android.plussdk.controller.model

import android.content.Context
import com.google.gson.Gson
import com.google.gson.reflect.TypeToken
import java.io.IOException

internal object UtilsConfig {
    fun getConfiguration(context: Context, fileName: String): List<SensitivityModel> {
        val jsonFileString = getJsonDataFromAsset(context.applicationContext, fileName)
        val gson = Gson()
        val list = object : TypeToken<List<SensitivityModel>>() {}.type
        return gson.fromJson(jsonFileString, list)
    }

    private fun getJsonDataFromAsset(context: Context, fileName: String): String? {
        val jsonString: String
        try {
            jsonString = context.assets.open(fileName).bufferedReader().use { it.readText() }
        } catch (ioException: IOException) {
            ioException.printStackTrace()
            return null
        }
        return jsonString
    }
}
