package app.pivo.android.plussdk.controller

import android.content.Context
import app.pivo.android.plussdk.controller.model.SensitivityValue
import app.pivo.android.plussdk.controller.model.TrackingType
import java.lang.ref.WeakReference

class PivoConfigulation(context: Context): Configuration {

    private val contextReference = WeakReference(context)
    private var sensitivityConfiguration: SensitivityConfiguration? = null
    private var config: TrackingConfig? = null

    override fun initConfig(sensitivityValue: SensitivityValue, trackingType: TrackingType) {
        contextReference.get()?.let { context ->
            config = TrackingConfig(context, trackingType)
        }

        config?.let {
            val sensitivityModel = it.getSensitivity(sensitivityValue)
            sensitivityConfiguration = SensitivityConfigurationType(sensitivityModel)
        } ?: kotlin.run {
            throw Exception("Could not get Configuration")
        }

    }

    override fun getSensitivityConfig(): SensitivityConfiguration? {
        return sensitivityConfiguration
    }
}