package app.pivo.android.plussdk.controller

import app.pivo.android.plussdk.controller.model.PDValues
import app.pivo.android.plussdk.controller.model.SensitivityModel
import app.pivo.android.plussdk.controller.model.TwoDimensional

internal class SensitivityConfigurationType(
    private val sensitivityModel: SensitivityModel,
) : SensitivityConfiguration {
    override fun getMinSpeed(): TwoDimensional<Float> {
        return TwoDimensional(sensitivityModel.hPdValues.minSpeed, sensitivityModel.vPdValues.minSpeed)
    }

    override fun getMaxSpeed(): TwoDimensional<Float> {
        return TwoDimensional(sensitivityModel.hPdValues.maxSpeed, sensitivityModel.vPdValues.maxSpeed)
    }

    override fun getRangeSpeed(): TwoDimensional<Float> {
        val maxSpeed = getMaxSpeed()
        val minSpeed = getMinSpeed()
        return TwoDimensional(maxSpeed.x - minSpeed.x, maxSpeed.y - minSpeed.y)
    }

    override fun getPDValues(): TwoDimensional<PDValues> {
        return TwoDimensional(getHPDValues(), getVPDValues())
    }

    override fun getHPDValues(): PDValues {
        return sensitivityModel.hPdValues
    }

    override fun getVPDValues(): PDValues {
        return sensitivityModel.vPdValues
    }
}
