// Copyright 2018 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
package app.pivo.android.plussdk;

import android.media.Image;


import java.nio.ByteBuffer;

import app.pivo.android.plussdk.tracking.FrameMetadata;
import app.pivo.android.plussdk.tracking.GraphicOverlay;

/** An inferface to process the images with different detectors and custom image models. */
interface VisionImageProcessor {

  /** Processes the images with the underlying machine learning models. */
  default void process(ByteBuffer data, FrameMetadata frameMetadata, GraphicOverlay graphicOverlay){}

  /** Processes the images with the underlying machine learning models. */
  default void process(Image data, FrameMetadata frameMetadata, GraphicOverlay graphicOverlay){}

  /** Processes the images with the underlying machine learning models. */
  default void process(byte[] data, FrameMetadata frameMetadata, GraphicOverlay graphicOverlay){}

  /** Stops the underlying machine learning model and release resources. */
  void stop();
}
