package app.pivo.android.plussdk.controller

import android.content.Context
import android.util.Log
import app.pivo.android.plussdk.controller.model.SensitivityModel
import app.pivo.android.plussdk.controller.model.SensitivityValue
import app.pivo.android.plussdk.controller.model.TrackingType
import app.pivo.android.plussdk.controller.model.UtilsConfig

internal class TrackingConfig(
    context: Context,
    trackingType: TrackingType
) {
    private val sensitivities = getConfig(context, trackingType)

    fun getSensitivity(sensitivityMode: SensitivityValue): SensitivityModel {
        Log.d("GetSensitivitiy", "sensitivities size:" + sensitivities.size)
        val sensitivity = sensitivities.filter {
            it.sensitivityMode == sensitivityMode
        }

        if (sensitivity.isEmpty())
            throw Exception("Config was not found")

        return sensitivity[0]
    }

    private fun getConfig(context: Context, trackingType: TrackingType): List<SensitivityModel> {
        return when (trackingType) {
            TrackingType.FACE -> UtilsConfig.getConfiguration(context, "config2Face.json")
            TrackingType.BODY -> UtilsConfig.getConfiguration(context, "config2Body.json")
            TrackingType.HORSE -> UtilsConfig.getConfiguration(context, "config2Horse.json")
            TrackingType.DOG -> UtilsConfig.getConfiguration(context, "config2Dog.json")
            TrackingType.NONE -> emptyList()
        }
    }
}