package app.pivo.android.plussdk;

import android.graphics.Rect;
import android.util.Log;

import androidx.annotation.Keep;

import java.nio.ByteBuffer;

import app.pivo.android.plussdk.tracking.FrameMetadata;
import app.pivo.android.plussdk.util.ITrackingListener;


/**
 * Created by Murodjon on 2/8/19.
 */
class ActionTracker {
    public static final int PORTRAIT = 1;
    public static final int LANDSCAPE = 2;

    private int frameWidth = 0;
    private int frameHeight = 0;

    private ITrackingListener mListener;

    public ActionTracker(ITrackingListener listener){
        mListener = listener;
    }

    public void initCamera(byte[] data, int imgFormat, int width, int height, Rect roi, int camFacing, int orientation,int orientationEnabled){

        frameHeight = width;
        frameWidth = height;
        initTrackerCameraApi1(data, imgFormat, width, height, Math.abs(roi.left - roi.right), Math.abs(roi.top - roi.bottom), roi.left, roi.top, camFacing,
                orientation,orientationEnabled);
    }

    public void updateCameraFrame(byte[] data, int imgFormat, FrameMetadata metadata, int camFacing, int orientation, int orientationEnabled){
        if (mListener!=null){
            frameWidth = metadata.getHeight();
            frameHeight = metadata.getWidth();
            updateFrameCameraApi1(data, imgFormat,metadata.getWidth(), metadata.getHeight(), camFacing, orientation,orientationEnabled);
        }
    }
    public void updateCameraFrame(byte[] data, int imgFormat, int w, int h, int camFacing, int orientation,int orientationEnabled){
        if (mListener!=null){
            updateFrameCameraApi1(data, imgFormat,w, h, camFacing, orientation,orientationEnabled);
        }
    }

    public native void initTrackerCameraApi1(byte[] nv21FrameData, int imgFormat, int width, int height, int rWidth, int rHeight, int x, int y, int camFacing, int orientation,int mode);

    public native void updateFrameCameraApi1(byte[] nv21FrameData, int imgFormat, int width, int height, int cameFacing, int orientation,int mode);

    public native void initTracker(ByteBuffer data, int imgFormat, int width, int height, int rWidth, int rHeight, int x, int y);

    public native void updateFrame(ByteBuffer data, int imgFormat, int width, int height);

    @Keep
    public void CallbackTrack(int x, int y, int width, int height){
        if(mListener!=null){
            mListener.onTracking(x, y, width, height);
            mListener.onTracking(x, y, width, height, frameWidth, frameHeight);
        }
    }

    static {
        try {
            Log.d("ActionTracking", "Tracker native is loaded!!");
            System.loadLibrary("objtracking-lib");
        } catch (Exception e) {
            Log.d("ActionTracking", "Tracker native is not loaded! - Failed!");
            e.printStackTrace();
        }
    }
}
