package app.pivo.android.plussdk;

import android.content.Context;
import android.graphics.PointF;
import android.graphics.Rect;
import android.media.Image;
import android.util.Log;

import app.pivo.android.basicsdk.PivoSdk;
import app.pivo.android.basicsdk.exceptions.NotAllowedFeatureException;
import app.pivo.android.plussdk.controller.model.SensitivityValue;
import app.pivo.android.plussdk.controller.model.TrackingType;
import app.pivo.android.plussdk.tracking.FrameMetadata;
import app.pivo.android.plussdk.util.ITrackingListener;
import app.pivo.android.sdk.controller.FeatureType;

public class PivoPlusSdk extends PivoSdk {

    private final String TAG = this.getClass().getSimpleName();
    static PivoPlusSdk instance;
    private final IFrameProcessingTask frameProcessing;

    private FrameMetadata frameMetadata;
    private static Context mContext;
    private SensitivityMode sensitivityMode = SensitivityMode.NORMAL;

    private NativeController nativeController = null;
    public static PivoPlusSdk getInstance(){
        return instance;
    }

    public static void init(Context context){
        instance = new PivoPlusSdk(context);
        mContext = context;
    }

    PivoPlusSdk(Context context){
        // frame processing tasks
        frameProcessing = new FrameProcessingTask
                .Builder()
                .setContext(context)
                .build();

        if (nativeController == null) {
            nativeController = new NativeController();
        }

    }

    public void startActionTracking(FrameMetadata metadata, Rect region, Image image, PivoSensitivity sensitivity, ITrackingListener listener) throws NotAllowedFeatureException {
        if (image==null || region==null || listener == null || metadata == null || sensitivity == null){
            Log.e(TAG, "startActionTracking() ->  Some of the arguments you're sending is null.");
            return;
        }

        if (!featureAvaiable(FeatureType.ACTION)) throw new NotAllowedFeatureException("Now allowed feature : Action");

        setSensitivityMode(sensitivity);

        frameMetadata = metadata;
        nativeController.initConfig(mContext, getSensitivity(sensitivity), TrackingType.BODY);
        nativeController.setMetadata(frameMetadata);
        this.outListener = listener;
        if (isVerified()) {
            frameProcessing.startActionTracking(metadata, region, image, mListener);
        }
    }

    public void startActionTracking(FrameMetadata metadata, Rect region, byte[] image, PivoSensitivity sensitivity, ITrackingListener listener) throws NotAllowedFeatureException  {
        if (image==null || region==null || listener == null || metadata == null || sensitivity == null){
            Log.e(TAG, "startActionTracking() ->  Some of the arguments you're sending is null.");
            return;
        }

        if (!featureAvaiable(FeatureType.ACTION)) throw new NotAllowedFeatureException("Now allowed feature : Action");

        setSensitivityMode(sensitivity);

        frameMetadata = metadata;
        nativeController.initConfig(mContext, getSensitivity(sensitivity), TrackingType.BODY);
        nativeController.setMetadata(frameMetadata);
        this.outListener = listener;
        if (isVerified()){
            frameProcessing.startActionTracking(metadata, region, image, mListener);
        }
    }

    public void starPersonTracking(FrameMetadata metadata, Image image, PivoSensitivity sensitivity, ITrackingListener listener) throws NotAllowedFeatureException {
        if (image==null || metadata==null || listener == null|| sensitivity == null){
            Log.e(TAG, "starPersonTracking() -> Some of the arguments you're sending is null.");
            return;
        }

        if (!featureAvaiable(FeatureType.BODY)) throw new NotAllowedFeatureException("Now allowed feature : Body");

        setSensitivityMode(sensitivity);

        frameMetadata = metadata;
        nativeController.initConfig(mContext, getSensitivity(sensitivity), TrackingType.BODY);
        nativeController.setMetadata(frameMetadata);
        this.outListener = listener;
        if (isVerified()){
            frameProcessing.startPersonTracking(metadata, image, mListener);
        }
    }

    public void starPersonTracking(FrameMetadata metadata, byte[] image, PivoSensitivity sensitivity, ITrackingListener listener) throws NotAllowedFeatureException {
        if (image==null || metadata==null || listener == null|| sensitivity == null){
            Log.e(TAG, "starPersonTracking() -> Some of the arguments you're sending is null.");
            return;
        }

        if (!featureAvaiable(FeatureType.BODY)) throw new NotAllowedFeatureException("Now allowed feature : Body");

        setSensitivityMode(sensitivity);

        frameMetadata = metadata;
        nativeController.initConfig(mContext, getSensitivity(sensitivity), TrackingType.BODY);
        nativeController.setMetadata(frameMetadata);
        this.outListener = listener;
        if (isVerified()){
            frameProcessing.startPersonTracking(metadata, image, mListener);
        }
    }

    public void startFaceTracking(FrameMetadata metadata, Image image, PivoSensitivity sensitivity, ITrackingListener listener) throws NotAllowedFeatureException {
        if (image==null || metadata==null || listener == null|| sensitivity == null){
            Log.e(TAG, "startFaceTracking() -> Some of the arguments you're sending is null.");
            return;
        }

        if (!featureAvaiable(FeatureType.FACE)) throw new NotAllowedFeatureException("Now allowed feature : Face");

        setSensitivityMode(sensitivity);

        frameMetadata = metadata;
        nativeController.initConfig(mContext, getSensitivity(sensitivity), TrackingType.FACE);
        nativeController.setMetadata(frameMetadata);
        this.outListener = listener;
        if (isVerified()){
            frameProcessing.startFaceTracking(metadata, image, mListener);
        }
    }

    public void startFaceTracking(FrameMetadata metadata, byte[] image, PivoSensitivity sensitivity, ITrackingListener listener) throws NotAllowedFeatureException {
        if (image==null || metadata==null || listener == null|| sensitivity == null){
            Log.e(TAG, "startFaceTracking() -> Some of the arguments you're sending is null.");
            return;
        }

        if (!featureAvaiable(FeatureType.FACE)) throw new NotAllowedFeatureException("Now allowed feature : Face");

        setSensitivityMode(sensitivity);

        frameMetadata = metadata;
        nativeController.initConfig(mContext, getSensitivity(sensitivity), TrackingType.FACE);
        nativeController.setMetadata(frameMetadata);
        this.outListener = listener;
        if (isVerified()){
            frameProcessing.startFaceTracking(metadata, image, mListener);
        }
    }

    public void startDogTracking(FrameMetadata metadata, Image image,PivoSensitivity sensitivity, ITrackingListener listener) throws NotAllowedFeatureException {
        if (image==null || metadata==null || listener == null|| sensitivity == null){
            Log.e(TAG, "startDogTracking() -> Some of the arguments you're sending is null.");
            return;
        }

        if (!featureAvaiable(FeatureType.DOG)) throw new NotAllowedFeatureException("Now allowed feature : Dog");

        setSensitivityMode(sensitivity);

        frameMetadata = metadata;
        nativeController.initConfig(mContext, getSensitivity(sensitivity), TrackingType.DOG);
        nativeController.setMetadata(frameMetadata);
        this.outListener = listener;
        if (isVerified()){
            frameProcessing.startDogTracking(metadata, image, mListener);
        }
    }

    public void startDogTracking(FrameMetadata metadata, byte[] image, PivoSensitivity sensitivity, ITrackingListener listener) throws NotAllowedFeatureException {
        if (image==null || metadata==null || listener == null|| sensitivity == null){
            Log.e(TAG, "startDogTracking() -> Some of the arguments you're sending is null.");
            return;
        }

        if (!featureAvaiable(FeatureType.DOG)) throw new NotAllowedFeatureException("Now allowed feature : Dog");

        setSensitivityMode(sensitivity);

        frameMetadata = metadata;
        nativeController.initConfig(mContext, getSensitivity(sensitivity), TrackingType.DOG);
        nativeController.setMetadata(frameMetadata);
        this.outListener = listener;
        if (isVerified()){
            frameProcessing.startDogTracking(metadata, image, mListener);
        }
    }

    public void startHorseTracking(FrameMetadata metadata, Image image,PivoSensitivity sensitivity, ITrackingListener listener) throws NotAllowedFeatureException {
        if (image==null || listener == null || metadata==null || sensitivity == null){
            Log.e(TAG, "startHorseTracking() -> Some of the arguments you're sending is null.");
            return;
        }

        if (!featureAvaiable(FeatureType.HORSE)) throw new NotAllowedFeatureException("Now allowed feature : Horse");

        setSensitivityMode(sensitivity);

        frameMetadata = metadata;
        nativeController.initConfig(mContext, getSensitivity(sensitivity), TrackingType.HORSE);
        nativeController.setMetadata(frameMetadata);
        this.outListener = listener;
        if (isVerified()){
            frameProcessing.startHorseTracking(metadata, image, mListener);
        }
    }

    public void startHorseTracking(FrameMetadata metadata, byte[] image, PivoSensitivity sensitivity, ITrackingListener listener) throws NotAllowedFeatureException {
        if (image==null || listener == null || metadata==null || sensitivity == null){
            Log.e(TAG, "startHorseTracking() -> Some of the arguments you're sending is null.");
            return;
        }

        if (!featureAvaiable(FeatureType.HORSE)) throw new NotAllowedFeatureException("Now allowed feature : Horse");

        setSensitivityMode(sensitivity);

        frameMetadata = metadata;
        nativeController.initConfig(mContext, getSensitivity(sensitivity), TrackingType.HORSE);
        nativeController.setMetadata(frameMetadata);
        this.outListener = listener;
        if (isVerified()){
            frameProcessing.startHorseTracking(metadata, image, mListener);
        }
    }

    public void stopTracking(){
        frameProcessing.stopTracking();
    }

    public void updateTrackingFrame(Image image, FrameMetadata metadata) {
        if (image==null){
            Log.e(TAG, "updateTrackingFrame()-> Image object is null");
            return;
        }
        if (isVerified() && frameProcessing.isTrackingOn()){
            frameMetadata = metadata;
            nativeController.resumeDispatching();
            nativeController.setMetadata(frameMetadata);
            frameProcessing.update(image, metadata);
        } else {
            nativeController.pauseDispatching();
        }
    }

    public void updateTrackingFrame(byte[] image, FrameMetadata metadata) {
        if (image==null){
            Log.e(TAG, "updateTrackingFrame()-> Image object is null");
            return;
        }
        if (isVerified() && frameProcessing.isTrackingOn()){
            frameMetadata = metadata;
            nativeController.setMetadata(frameMetadata);
            frameProcessing.update(image, metadata);
        } else {
            nativeController.pauseDispatching();
        }
    }

    public void pauseTracking() {
        nativeController.pauseDispatching();
    }

    public void resumeTracking() {
        nativeController.resumeDispatching();
    }

    private void setSensitivityMode(PivoSensitivity sensitivity) {
        switch (sensitivity){
            case NONE:
                sensitivityMode = SensitivityMode.NONE;
                break;
            case NORMAL:
                sensitivityMode = SensitivityMode.NORMAL;
                break;
            case SLOW:
                sensitivityMode = SensitivityMode.SLOW;
                break;
            case FAST:
                sensitivityMode = SensitivityMode.FAST;
                break;
            case FRENZY:
                sensitivityMode = SensitivityMode.FRENZY;
                break;
        }
    }

    private SensitivityValue getSensitivity(PivoSensitivity sensitivity) {
        if (sensitivity == PivoSensitivity.SLOW)
            return SensitivityValue.SLOW;
        else if (sensitivity == PivoSensitivity.NORMAL)
            return SensitivityValue.NORMAL;
        else if (sensitivity == PivoSensitivity.FAST)
            return SensitivityValue.FAST;
        else if (sensitivity == PivoSensitivity.FRENZY)
            return SensitivityValue.FRENZY;
        else
            return SensitivityValue.NORMAL;
    }

    private ITrackingListener outListener;
    private final ITrackingListener mListener = new ITrackingListener() {

        @Override
        public void onTracking(int x, int y, int width, int height, int frameWidth, int frameHeight) {
            Rect rect = new Rect(x, y, x + width, y + height);
            frameProcessing.setTargetToTrack(rect);

            if (frameProcessing.getTracker() != null) {
                outListener.onTracking(frameProcessing.getTracker().draw());
            }

            outListener.onTracking(x, y, width, height, frameWidth, frameHeight);

            nativeController.track(new PointF(x + width / 2.f, y + height / 2.f));
        }

        @Override
        public void onClear() {
            outListener.onClear();
        }
    };
}
